/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.tree.JumpInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LabelNode;

final class Subroutine {
    final LabelNode start;
    final boolean[] localsUsed;
    final List<JumpInsnNode> callers;

    Subroutine(LabelNode labelNode, int n, JumpInsnNode jumpInsnNode) {
        this.start = labelNode;
        this.localsUsed = new boolean[n];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(jumpInsnNode);
    }

    Subroutine(Subroutine subroutine) {
        this.start = subroutine.start;
        this.localsUsed = new boolean[subroutine.localsUsed.length];
        this.callers = new ArrayList<JumpInsnNode>(subroutine.callers);
        System.arraycopy(subroutine.localsUsed, 0, this.localsUsed, 0, subroutine.localsUsed.length);
    }

    public boolean merge(Subroutine subroutine) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.localsUsed.length; ++n) {
            if (!subroutine.localsUsed[n] || this.localsUsed[n]) continue;
            this.localsUsed[n] = true;
            bl = true;
        }
        if (subroutine.start == this.start) {
            for (n = 0; n < subroutine.callers.size(); ++n) {
                JumpInsnNode jumpInsnNode = subroutine.callers.get(n);
                if (this.callers.contains(jumpInsnNode)) continue;
                this.callers.add(jumpInsnNode);
                bl = true;
            }
        }
        return bl;
    }
}

