/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Resource;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class TransparentIndirectionAddOverflowBehaviourTest
extends AutoVerifyTestCase {
    public SalesPerson transfer;
    public FieldOffice clone;
    public FieldOffice clone2;
    public Resource resource;

    public TransparentIndirectionAddOverflowBehaviourTest() {
        this.setDescription("This test verifies that Tranparent Indirection works with change tracking. Specifically it verifies that mutliple calls to add have the same behavour as deferred detection.");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.clone = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Toronto"));
        this.clone2 = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Ottawa"));
        this.transfer = (SalesPerson)this.clone.getSalespeople().iterator().next();
        this.clone.getSalespeople().remove(this.transfer);
        this.clone2.getSalespeople().add(this.transfer);
        this.clone2.getSalespeople().add(this.transfer);
        this.clone2.getSalespeople().remove(this.transfer);
        this.resource = (Resource)this.clone.getResources().iterator().next();
        this.clone.getResources().remove(this.resource);
        this.clone2.getResources().add(this.resource);
        this.clone2.getResources().add(this.resource);
        this.clone2.getResources().remove(this.resource);
        uow.commit();
    }

    public void verify() {
        FieldOffice cachedOffice2 = (FieldOffice)this.getSession().readObject((Object)this.clone2);
        SalesPerson cachedTransfer = (SalesPerson)this.getSession().readObject((Object)this.transfer);
        Resource cachedResource = (Resource)this.getSession().readObject((Object)this.resource);
        if (cachedOffice2.getSalespeople().contains(cachedTransfer)) {
            throw new TestErrorException("Failed to replicate Set behavior for double add when tracking changes");
        }
        if (!cachedOffice2.getResources().contains(cachedResource)) {
            throw new TestErrorException("Failed to replicate List behavior for double add when tracking changes");
        }
    }
}

