/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class ConversionValueMetadata
extends ORMetadata {
    private String m_dataValue;
    private String m_objectValue;

    public ConversionValueMetadata() {
        super("<conversion-value");
    }

    public ConversionValueMetadata(MetadataAnnotation conversionValue, MetadataAccessor accessor) {
        super(conversionValue, accessor);
        this.m_dataValue = conversionValue.getAttributeString("dataValue");
        this.m_objectValue = conversionValue.getAttributeString("objectValue");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConversionValueMetadata) {
            ConversionValueMetadata conversionValue = (ConversionValueMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_dataValue, conversionValue.getDataValue())) {
                return false;
            }
            return this.valuesMatch(this.m_objectValue, conversionValue.getObjectValue());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_dataValue != null ? this.m_dataValue.hashCode() : 0;
        result = 31 * result + (this.m_objectValue != null ? this.m_objectValue.hashCode() : 0);
        return result;
    }

    public String getDataValue() {
        return this.m_dataValue;
    }

    public String getObjectValue() {
        return this.m_objectValue;
    }

    public void setDataValue(String dataValue) {
        this.m_dataValue = dataValue;
    }

    public void setObjectValue(String objectValue) {
        this.m_objectValue = objectValue;
    }
}

