/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.writing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;

public class ComplexUpdateTest
extends WriteObjectTest {
    public Object workingCopy;
    public boolean usesUnitOfWork = false;
    public boolean usesNestedUnitOfWork = false;
    public boolean shouldCommitParent = false;
    public boolean shouldCompareClone = true;

    public ComplexUpdateTest() {
    }

    public ComplexUpdateTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeObject() {
    }

    public void commitParentUnitOfWork() {
        this.useNestedUnitOfWork();
        this.shouldCommitParent = true;
    }

    public String getName() {
        return super.getName() + Boolean.valueOf(this.usesUnitOfWork) + Boolean.valueOf(this.usesNestedUnitOfWork);
    }

    public void reset() {
        if (this.getExecutor().getSession().isUnitOfWork()) {
            this.getExecutor().setSession((Session)((UnitOfWork)this.getSession()).getParent());
            if (this.getExecutor().getSession().isUnitOfWork()) {
                this.getExecutor().setSession((Session)((UnitOfWork)this.getSession()).getParent());
            }
        }
        super.reset();
    }

    protected void setup() {
        super.setup();
        if (this.usesUnitOfWork) {
            this.getExecutor().setSession((Session)this.getSession().acquireUnitOfWork());
            if (this.usesNestedUnitOfWork) {
                this.getExecutor().setSession((Session)this.getSession().acquireUnitOfWork());
            }
            this.workingCopy = ((UnitOfWork)this.getSession()).registerObject(this.objectToBeWritten);
        } else {
            this.workingCopy = this.objectToBeWritten;
        }
    }

    protected void test() {
        this.changeObject();
        if (this.usesUnitOfWork) {
            if (!((UnitOfWork)this.getSession()).getParent().compareObjects(this.originalObject, this.objectToBeWritten)) {
                throw new TestErrorException("The original object was changed through changing the clone.");
            }
            ((UnitOfWork)this.getSession()).commit();
            this.getExecutor().setSession((Session)((UnitOfWork)this.getSession()).getParent());
            if (this.usesNestedUnitOfWork) {
                if (this.shouldCommitParent) {
                    ((UnitOfWork)this.getSession()).commit();
                }
                this.getExecutor().setSession((Session)((UnitOfWork)this.getSession()).getParent());
            }
            if (this.shouldCompareClone) {
                ClassDescriptor descriptor = this.getSession().getClassDescriptor(this.objectToBeWritten);
                if (descriptor.shouldIsolateObjectsInUnitOfWork()) {
                    this.getSession().logMessage("ComplexUpdateTest: descriptor.shouldIsolateObjectsInUnitOfWork() == null. In this case object's changes are not merged back into parent's cache");
                } else if (descriptor.shouldIsolateProtectedObjectsInUnitOfWork() && this.getSession().isClientSession() ? !this.getAbstractSession().compareObjects(this.workingCopy, ((ClientSession)this.getSession()).getParent().getIdentityMapAccessor().getFromIdentityMap(this.workingCopy)) : !this.getAbstractSession().compareObjects(this.workingCopy, this.objectToBeWritten)) {
                    throw new TestErrorException("The clone does not match the cached object.");
                }
            }
        } else {
            super.test();
        }
    }

    public void useNestedUnitOfWork() {
        this.usesNestedUnitOfWork = true;
        this.usesUnitOfWork = true;
    }
}

