/*
 * Copyright (c) 1998, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
 package org.eclipse.persistence.testing.tests.junit.failover.emulateddriver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.util.Calendar;

public class EmulatedStatement implements PreparedStatement {

    protected EmulatedConnection connection;
    protected String sql;

    public EmulatedStatement(EmulatedConnection connection) {
        this.connection = connection;
    }

    public EmulatedStatement(String sql, EmulatedConnection connection) {
        this(connection);
        this.sql = sql;
    }


    public void checkForError() throws SQLException{
        if ((connection).isInFailureState()){
            SQLException exception = new SQLException("Communication Failure occurred", "", 17004);
            throw exception;
        }
    }


    public boolean execute() throws SQLException {
        checkForError();
        return true;
    }


    public boolean execute(String sql) throws SQLException {
        checkForError();
        return true;
    }


    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        checkForError();
        return true;
    }


    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        checkForError();
        return true;
    }


    public boolean execute(String sql, String[] columnNames) throws SQLException {
        checkForError();
        return true;
    }


    public ResultSet executeQuery() throws SQLException {
        checkForError();
        return new EmulatedResultSet(this.connection.getRows(this.sql));
    }


    public ResultSet executeQuery(String sql) throws SQLException {
        checkForError();
        return new EmulatedResultSet(this.connection.getRows(sql));
    }


    public int executeUpdate() throws SQLException {
        checkForError();
        return 1;
    }


    public int executeUpdate(String sql) throws SQLException {
        checkForError();
        return 1;
    }


    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        checkForError();
        return 1;
    }


    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        checkForError();
        return 1;
    }


    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        checkForError();
        return 1;
    }

    public void setNull(int parameterIndex, int sqlType) {
    }

    public void setBoolean(int parameterIndex, boolean x) {
    }

    public void setByte(int parameterIndex, byte x) {
    }

    public void setShort(int parameterIndex, short x) {
    }

    public void setInt(int parameterIndex, int x) {
    }

    public void setLong(int parameterIndex, long x) {
    }

    public void setFloat(int parameterIndex, float x) {
    }

    public void setDouble(int parameterIndex, double x) {
    }


    public void setBigDecimal(int parameterIndex, BigDecimal x) {
    }


    public void setString(int parameterIndex, String x) {
    }


    public void setBytes(int parameterIndex, byte[] x) {
    }


    public void setDate(int parameterIndex, java.sql.Date x) {
    }


    public void setTime(int parameterIndex, java.sql.Time x) {
    }


    public void setTimestamp(int parameterIndex, java.sql.Timestamp x) {
    }


    public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    public void setBinaryStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    public void clearParameters() {
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) {
    }


    public void setObject(int parameterIndex, Object x, int targetSqlType) {
    }


    public void setObject(int parameterIndex, Object x) {
    }

    public void addBatch() {
    }


    public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) {
    }


    public void setRef(int i, Ref x) {
    }


    public void setBlob(int i, Blob x) {
    }


    public void setClob(int i, Clob x) {
    }


    public void setArray(int i, Array x) {
    }


    public ResultSetMetaData getMetaData() {
        return null;
    }


    public void setDate(int parameterIndex, java.sql.Date x, Calendar cal) {
    }


    public void setTime(int parameterIndex, java.sql.Time x, Calendar cal) {
    }


    public void setTimestamp(int parameterIndex, java.sql.Timestamp x, Calendar cal) {
    }


    public void setNull(int paramIndex, int sqlType, String typeName) {
    }


    public void setURL(int parameterIndex, java.net.URL x) {
    }


    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    public void close() {
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public void setMaxFieldSize(int max) {
    }

    public int getMaxRows() {
        return 0;
    }

    public void setMaxRows(int max) {
    }

    public void setEscapeProcessing(boolean enable) {
    }

    public int getQueryTimeout() {
        return 0;
    }

    public void setQueryTimeout(int seconds) {
    }

    public void cancel() {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public void setCursorName(String name) {
    }

    public ResultSet getResultSet() {
        return null;
    }

    public int getUpdateCount() {
        return 0;
    }

    public boolean getMoreResults() {
        return false;
    }

    public void setFetchDirection(int direction) {
    }

    public int getFetchDirection() {
        return 0;
    }

    public void setFetchSize(int rows) {
    }

    public int getFetchSize() {
        return 0;
    }

    public int getResultSetConcurrency() {
        return 0;
    }
    public int getResultSetType() {
        return 0;
    }

    public void addBatch(String sql) {
    }

    public void clearBatch() {
    }

    public int[] executeBatch(){
        return null;
    }
    public Connection getConnection() {
        return connection;
    }

    public boolean getMoreResults(int current) {
        return false;
    }

    public ResultSet getGeneratedKeys() {
        return null;
    }

    public int getResultSetHoldability() {
        return 0;
    }

    // 236070: Methods introduced in JDK 1.6

   public void setAsciiStream(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   public void setAsciiStream(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setAsciiStream(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setAsciiStream(String columnLabel, InputStream stream)  throws SQLException {
   }

   public void setBlob(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   public void setBlob(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setBlob(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setBlob(String columnLabel, InputStream stream)  throws SQLException {
   }

   public void setBinaryStream(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   public void setBinaryStream(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setBinaryStream(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setBinaryStream(String columnLabel, InputStream stream)  throws SQLException {
   }

   public void setCharacterStream(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   public void setCharacterStream(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setCharacterStream(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setCharacterStream(String columnLabel, Reader reader)  throws SQLException {
   }

   public void setClob(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   public void setClob(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setClob(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setClob(String columnLabel, Reader reader)  throws SQLException {
   }

   public void setNCharacterStream(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   public void setNCharacterStream(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setNCharacterStream(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setNCharacterStream(String columnLabel, Reader reader)  throws SQLException {
   }

   public void setNClob(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   public void setNClob(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setNClob(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setNClob(String columnLabel, Reader reader)  throws SQLException {
   }

   public void setNClob(int columnIndex, NClob nclob)  throws SQLException {
   }

   public void setNClob(String columnLabel, NClob nclob)  throws SQLException {
   }

   public void setNString(int columnIndex, String nString)  throws SQLException {
   }

   public void setNString(String columnLabel, String nString)  throws SQLException {
   }

   public void setSQLXML(String columnLabel, SQLXML sqlxml)  throws SQLException {
   }

   public void setSQLXML(int columnIndex, SQLXML sqlxml)  throws SQLException {
   }

   public void setRowId(int columnIndex, RowId rowid)  throws SQLException {
   }

   public void setRowId(String columnLabel, RowId rowid)  throws SQLException {
   }

   public boolean isClosed()  throws SQLException {
       return false;
   }

   public boolean isPoolable()  throws SQLException {
       return false;
   }

   public void setPoolable(boolean poolable)  throws SQLException {
   }

    // From java.sql.Wrapper
    public boolean isWrapperFor(Class<?> iFace) throws SQLException{
        return false;
    }

    public <T>T unwrap(Class<T> iFace)  throws SQLException {
        return iFace.cast(this);
    }

    public boolean isCloseOnCompletion(){return false;}

    public void closeOnCompletion(){}
}
