/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class QueryTimeoutConnectionReleasedTest
extends TestCase {
    protected boolean queryTimeoutExceeded;
    protected int preConnectionsAvailable;
    protected int postConnectionsAvailable;
    protected ServerSession serverSession;

    public QueryTimeoutConnectionReleasedTest() {
        this.setDescription("Test the ServerSession releases pooled connections with a query returning a cursor and query timeout set");
    }

    public void setup() {
        this.preConnectionsAvailable = 0;
        this.postConnectionsAvailable = 0;
        this.queryTimeoutExceeded = false;
        this.serverSession = (ServerSession)this.getSession().getProject().createServerSession(5, 5);
        DatabaseLogin clonedLogin = (DatabaseLogin)this.getSession().getLogin().clone();
        this.serverSession.setLogin(clonedLogin);
        this.serverSession.login();
    }

    public void test() {
        if (this.getSession().getPlatform().isSymfoware()) {
            this.throwWarning("Test QueryTimeoutConnectionReleasedTest skipped for this platform, the driver does not support query timeout. (bug 304905)");
        }
        if (this.getSession().getPlatform().isMaxDB()) {
            this.throwWarning("Test QueryTimeoutConnectionReleasedTest skipped for this platform, the driver does not support query timeout. (bug 326503)");
        }
        if (this.getSession().getPlatform().isHANA()) {
            this.throwWarning("Test QueryTimeoutConnectionReleasedTest skipped for this platform, the driver does not support query timeout. (bug 384135)");
        }
        this.preConnectionsAvailable = this.serverSession.getReadConnectionPool().getConnectionsAvailable().size();
        try {
            DataReadQuery query = new DataReadQuery();
            String sqlString = "SELECT SUM(e.EMP_ID) from EMPLOYEE e , EMPLOYEE b, EMPLOYEE c, EMPLOYEE d, EMPLOYEE f, EMPLOYEE g, EMPLOYEE h, EMPLOYEE i";
            query.setSQLString(sqlString);
            query.setQueryTimeout(1);
            query.useCursoredStream(1, 1);
            this.serverSession.acquireClientSession().executeQuery((DatabaseQuery)query);
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                this.queryTimeoutExceeded = true;
            }
        }
        finally {
            this.postConnectionsAvailable = this.serverSession.getReadConnectionPool().getConnectionsAvailable().size();
        }
    }

    public void verify() {
        if (this.queryTimeoutExceeded) {
            if (this.preConnectionsAvailable != this.postConnectionsAvailable) {
                throw new TestErrorException("Number of connections available in pool is: " + this.postConnectionsAvailable + " expected: " + this.preConnectionsAvailable);
            }
        } else {
            throw new TestErrorException("Query timeout was not exceeded, this is required for correct testing");
        }
    }

    public void reset() {
        if (this.serverSession != null) {
            this.serverSession.logout();
            this.serverSession.release();
        }
    }
}

