/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiFunction;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.VectorUtils;

public class NamespaceResolverStorage
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = -4697397620139076774L;
    private transient Vector namespaces = VectorUtils.emptyVector();
    private transient boolean modified = false;

    public NamespaceResolverStorage() {
    }

    public NamespaceResolverStorage(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public String put(String key, String value) {
        String response = super.put(key, value);
        this.setModified();
        return response;
    }

    private void setModified() {
        this.setModified(true);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        super.putAll(m);
        this.setModified();
    }

    @Override
    public String remove(Object key) {
        if (this.containsKey(key)) {
            this.setModified();
        }
        return (String)super.remove(key);
    }

    @Override
    public String putIfAbsent(String key, String value) {
        String response = super.putIfAbsent(key, value);
        this.setModified();
        return response;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean response = super.remove(key, value);
        if (response) {
            this.setModified();
        }
        return response;
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        boolean response = super.replace(key, oldValue, newValue);
        if (response) {
            this.setModified(response);
        }
        return response;
    }

    @Override
    public String replace(String key, String value) {
        String response = super.replace(key, value);
        this.setModified();
        return response;
    }

    public Vector getNamespaces() {
        if (this.isModified()) {
            this.namespaces = this.buildNamespacesUnmodifiable();
            this.setModified(false);
        }
        return this.namespaces;
    }

    public void setNamespaces(Vector namespaces) {
        super.clear();
        for (Namespace namespace : namespaces) {
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            super.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
        this.setModified();
    }

    private boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        this.modified = modified;
    }

    private Vector buildNamespacesUnmodifiable() {
        Vector<Namespace> names = new Vector<Namespace>(this.size());
        for (Map.Entry<String, String> entry : this.entrySet()) {
            Namespace namespace = new Namespace(entry.getKey(), entry.getValue());
            names.addElement(namespace);
        }
        return VectorUtils.unmodifiableVector(names);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
        super.replaceAll(function);
        this.setModified();
    }
}

