/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.io.OptionalDataException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import sun.misc.Unsafe;

public abstract class BridgeBase {
    public static final long INVALID_FIELD_OFFSET = -1L;
    private final Unsafe unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                throw new Error("Could not access Unsafe", exc);
            }
        }
    });

    public final int getInt(Object o, long offset) {
        return this.unsafe.getInt(o, offset);
    }

    public final void putInt(Object o, long offset, int x) {
        if (offset != -1L) {
            this.unsafe.putInt(o, offset, x);
        }
    }

    public final <T> T getObject(Object o, long offset) {
        return (T)this.unsafe.getObject(o, offset);
    }

    public final void putObject(Object o, long offset, Object x) {
        if (offset != -1L) {
            this.unsafe.putObject(o, offset, x);
        }
    }

    public final boolean getBoolean(Object o, long offset) {
        return this.unsafe.getBoolean(o, offset);
    }

    public final void putBoolean(Object o, long offset, boolean x) {
        if (offset != -1L) {
            this.unsafe.putBoolean(o, offset, x);
        }
    }

    public final byte getByte(Object o, long offset) {
        return this.unsafe.getByte(o, offset);
    }

    public final void putByte(Object o, long offset, byte x) {
        if (offset != -1L) {
            this.unsafe.putByte(o, offset, x);
        }
    }

    public final short getShort(Object o, long offset) {
        return this.unsafe.getShort(o, offset);
    }

    public final void putShort(Object o, long offset, short x) {
        if (offset != -1L) {
            this.unsafe.putShort(o, offset, x);
        }
    }

    public final char getChar(Object o, long offset) {
        return this.unsafe.getChar(o, offset);
    }

    public final void putChar(Object o, long offset, char x) {
        if (offset != -1L) {
            this.unsafe.putChar(o, offset, x);
        }
    }

    public final long getLong(Object o, long offset) {
        return this.unsafe.getLong(o, offset);
    }

    public final void putLong(Object o, long offset, long x) {
        if (offset != -1L) {
            this.unsafe.putLong(o, offset, x);
        }
    }

    public final float getFloat(Object o, long offset) {
        return this.unsafe.getFloat(o, offset);
    }

    public final void putFloat(Object o, long offset, float x) {
        if (offset != -1L) {
            this.unsafe.putFloat(o, offset, x);
        }
    }

    public final double getDouble(Object o, long offset) {
        return this.unsafe.getDouble(o, offset);
    }

    public final void putDouble(Object o, long offset, double x) {
        if (offset != -1L) {
            this.unsafe.putDouble(o, offset, x);
        }
    }

    public final long objectFieldOffset(Field f) {
        return this.unsafe.objectFieldOffset(f);
    }

    public final long staticFieldOffset(Field f) {
        return this.unsafe.staticFieldOffset(f);
    }

    public final void throwException(Throwable ee) {
        this.unsafe.throwException(ee);
    }

    @Deprecated
    public Class<?> defineClass(String className, byte[] classBytes, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        return this.unsafe.defineClass(className, classBytes, 0, classBytes.length, classLoader, null);
    }

    public Class<?> defineClass(Class<?> anchorClass, String className, byte[] classBytes) {
        return this.defineClass(className, classBytes, anchorClass.getClassLoader(), null);
    }

    public final void ensureClassInitialized(Class<?> cl) {
        this.unsafe.ensureClassInitialized(cl);
    }

    public abstract ClassLoader getLatestUserDefinedLoader();

    public abstract <T> Constructor<?> newConstructorForExternalization(Class<T> var1);

    public abstract <T> Constructor<T> newConstructorForSerialization(Class<T> var1, Constructor<?> var2);

    public abstract <T> Constructor<T> newConstructorForSerialization(Class<T> var1);

    public abstract boolean hasStaticInitializerForSerialization(Class<?> var1);

    public abstract MethodHandle writeObjectForSerialization(Class<?> var1) throws NoSuchMethodException, IllegalAccessException;

    public abstract MethodHandle readObjectForSerialization(Class<?> var1) throws NoSuchMethodException, IllegalAccessException;

    public abstract MethodHandle readResolveForSerialization(Class<?> var1);

    public abstract MethodHandle writeReplaceForSerialization(Class<?> var1);

    public abstract OptionalDataException newOptionalDataExceptionForSerialization(boolean var1);

    public Field toAccessibleField(Field field, Class callingClass) {
        field.setAccessible(true);
        return field;
    }

    public Method toAccessibleMethod(Method method, Class callingClass) {
        method.setAccessible(true);
        return method;
    }
}

