/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.adapters.jms;

import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.resource.cci.Connection;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionFactory;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionSpec;

public class JMSEISConnectionSpec
extends EISConnectionSpec {
    public static final String CONNECTION_FACTORY_URL = "factoryURL";
    public static final String CONNECTION_FACTORY = "factory";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        this.setConnectionFactory(new CciJMSConnectionFactory());
        if (this.getConnectionSpec() == null) {
            String username = (String)properties.get("user");
            String password = this.getPasswordFromProperties(properties);
            String url = (String)properties.get(CONNECTION_FACTORY_URL);
            ConnectionFactory factory = (ConnectionFactory)properties.get(CONNECTION_FACTORY);
            CciJMSConnectionSpec spec = new CciJMSConnectionSpec();
            if (username != null) {
                spec.setUsername(username);
            }
            if (password != null) {
                spec.setPassword(password);
            }
            if (url != null) {
                spec.setConnectionFactoryURL(url);
            }
            if (factory != null) {
                spec.setConnectionFactory(factory);
            }
            this.setConnectionSpec(spec);
        }
        return super.connectToDataSource(accessor, properties);
    }
}

