/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class NestedUnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public Object nestedUnitOfWorkWorkingCopy;
    public UnitOfWork nestedUnitOfWork;

    public NestedUnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeNestedUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.nestedUnitOfWorkWorkingCopy;
        employee.setNormalHours(new Time[3]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)2, (int)2, (int)2));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)2, (int)2, (int)2));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1903, (int)3, (int)3), Helper.dateFromYearMonthDate((int)1904, (int)4, (int)4)));
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("cell", "514", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("shop", "509", "8224599"));
        employee.addPhoneNumber(new PhoneNumber("fax", "509", "8224798"));
        employee.setProjects(new Vector());
        employee.addProject((Project)this.nestedUnitOfWork.readObject(SmallProject.class));
        employee.addProject(new SmallProject());
        employee.addProject(new SmallProject());
        employee.setResponsibilitiesList(new Vector());
        employee.addResponsibility("does not make cofffee");
        employee.addResponsibility("does not buy donuts");
        employee.setAddress(new EmployeePopulator().addressExample1());
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1901, (int)1, (int)1), Helper.dateFromYearMonthDate((int)1902, (int)2, (int)2)));
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("home", "613", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("office", "416", "8224599"));
        employee.setProjects(new Vector());
        employee.addProject((Project)this.unitOfWork.readObject(SmallProject.class));
        employee.addProject((Project)this.unitOfWork.readObject(LargeProject.class));
        employee.setResponsibilitiesList(new Vector());
        employee.addResponsibility("make coffee");
        employee.addResponsibility("buy donuts");
        employee.setAddress(new Address());
        employee.setManager((Employee)this.unitOfWork.readObject(Employee.class, new ExpressionBuilder().get("id").notEqual((Object)employee.getId())));
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!((AbstractSession)this.getSession()).compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.nestedUnitOfWork = this.unitOfWork.acquireUnitOfWork();
        this.nestedUnitOfWorkWorkingCopy = this.nestedUnitOfWork.registerObject(this.unitOfWorkWorkingCopy);
        this.changeNestedUnitOfWorkWorkingCopy();
        if (this.nestedUnitOfWork.registerObject(this.originalObject) == null) {
            throw new TestException("The nested uow register object returns null");
        }
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch(this.unitOfWorkWorkingCopy, this.nestedUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.nestedUnitOfWork.commit();
        if (!((AbstractSession)this.getSession()).compareObjects(this.unitOfWorkWorkingCopy, this.nestedUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The object in the nested unit of work has not been commited properly to its parent");
        }
        this.unitOfWork.commit();
    }
}

