/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class OneToManyMaxRowsSettingTest
extends AutoVerifyTestCase {
    private Vector employees;
    private Vector ssns;

    public OneToManyMaxRowsSettingTest() {
        this.setDescription("Tests setup the limit for the maximum number of rows the query returns");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setMaxRows(5);
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        DirectReadQuery query2 = new DirectReadQuery();
        query2.setSQLString("SELECT SSN FROM HOLDER");
        query2.setMaxRows(3);
        this.ssns = (Vector)this.getSession().executeQuery((DatabaseQuery)query2);
    }

    public void verify() {
        if (this.employees.size() != 5) {
            throw new TestErrorException("ReadAllQuery with setMaxRows test failed. mismatched objects returned");
        }
        if (this.ssns.size() != 3) {
            throw new TestErrorException("DirectReadQuery with setMaxRows test fails, mismatched objects returned");
        }
    }
}

