/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformResultsInUnitOfWorkTest;

public class ConformResultsWithPrimaryKeyExpressionTest
extends ConformResultsInUnitOfWorkTest {
    public static final int CASE_NEW = 0;
    public static final int CASE_DELETED = 1;
    public static final int CASE_EXISTING = 2;
    public static final int CASE_NOTEXISTING = 3;
    public final int testCase;
    public final boolean checkCacheByExactPrimaryKey;
    public int expectedGetIdCallCount;
    public int actualGetIdCallCount;
    Employee selectionObject;
    AttributeAccessor overwrittenAccessor;

    public ConformResultsWithPrimaryKeyExpressionTest(int testCase, boolean checkCacheByExactPrimaryKey) {
        this.testCase = testCase;
        this.checkCacheByExactPrimaryKey = checkCacheByExactPrimaryKey;
        String modifier = null;
        switch (testCase) {
            case 0: {
                modifier = "NEW";
                break;
            }
            case 1: {
                modifier = "DELETED";
                break;
            }
            case 2: {
                modifier = "EXISTING";
                break;
            }
            case 3: {
                modifier = "NOTEXISTING";
            }
        }
        if (this.shouldCheckCacheByExactPrimaryKey()) {
            this.setName("ConformResultsWithExactPrimaryKeyExpressionTest:" + modifier);
        } else {
            this.setName("ConformResultsWithInexactPrimaryKeyExpressionTest:" + modifier);
        }
    }

    @Override
    public void buildConformQuery() {
        this.conformedQuery = new ReadObjectQuery(Employee.class);
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression exactPrimaryKeyExpression = null;
        exactPrimaryKeyExpression = !this.getSession().getPlatform().isOracle() ? emp.get("id").equal((Object)this.selectionObject.getId()) : emp.get("id").equal((Object)("" + this.selectionObject.getId()));
        if (this.shouldCheckCacheByExactPrimaryKey()) {
            ((ReadObjectQuery)this.conformedQuery).setSelectionCriteria(exactPrimaryKeyExpression);
        } else {
            Expression inexactPrimaryKeyExpression = exactPrimaryKeyExpression.and(emp.get("firstName").equal((Object)this.selectionObject.getFirstName()));
            ((ReadObjectQuery)this.conformedQuery).setSelectionCriteria(inexactPrimaryKeyExpression);
        }
        this.conformedQuery.conformResultsInUnitOfWork();
    }

    public static Vector buildTests() {
        Vector<ConformResultsWithPrimaryKeyExpressionTest> tests = new Vector<ConformResultsWithPrimaryKeyExpressionTest>(4);
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(1, true));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(2, true));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(0, true));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(3, true));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(1, false));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(2, false));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(0, false));
        tests.add(new ConformResultsWithPrimaryKeyExpressionTest(3, false));
        return tests;
    }

    protected Employee findWorstCaseEmployee() {
        Vector searchOrder = this.unitOfWork.getIdentityMapAccessor().getAllFromIdentityMap(null, Employee.class, null, null);
        return (Employee)searchOrder.lastElement();
    }

    @Override
    public void prepareTest() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        for (int i = 0; i < employees.size() - 1; ++i) {
            this.unitOfWork.registerExistingObject(employees.elementAt(i));
        }
        Employee unregisteredEmployee = (Employee)employees.elementAt(employees.size() - 1);
        this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)unregisteredEmployee);
        int n = employees.size() - 1;
        Employee newEmployee = new Employee();
        newEmployee.setFirstName("Bobert");
        newEmployee.setLastName("Schmit");
        newEmployee.setId(new BigDecimal(45));
        this.unitOfWork.registerNewObject((Object)newEmployee);
        Employee registeredEmployee = this.findWorstCaseEmployee();
        switch (this.testCase) {
            case 0: {
                this.selectionObject = newEmployee;
                if (this.shouldCheckCacheByExactPrimaryKey()) {
                    this.expectedGetIdCallCount = 0;
                    break;
                }
                this.expectedGetIdCallCount = n + 1;
                break;
            }
            case 1: {
                this.selectionObject = registeredEmployee;
                this.unitOfWork.deleteObject((Object)this.selectionObject);
                if (this.shouldCheckCacheByExactPrimaryKey()) {
                    this.expectedGetIdCallCount = 0;
                    break;
                }
                this.expectedGetIdCallCount = 3;
                break;
            }
            case 2: {
                this.selectionObject = registeredEmployee;
                if (this.shouldCheckCacheByExactPrimaryKey()) {
                    this.expectedGetIdCallCount = 0;
                    break;
                }
                this.expectedGetIdCallCount = 1;
                break;
            }
            case 3: {
                this.selectionObject = unregisteredEmployee;
                this.expectedGetIdCallCount = this.shouldCheckCacheByExactPrimaryKey() ? 2 : n + 4;
            }
        }
    }

    @Override
    public void setup() {
        DatabaseMapping mapping = this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("id");
        this.overwrittenAccessor = mapping.getAttributeAccessor();
        mapping.setGetMethodName("getId");
        mapping.setSetMethodName("setId");
        mapping.getAttributeAccessor().initializeAttributes(Employee.class);
        super.setup();
    }

    @Override
    public void reset() {
        DatabaseMapping mapping = this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("id");
        mapping.setAttributeAccessor(this.overwrittenAccessor);
        super.reset();
    }

    @Override
    public void test() {
        int initialCount = Employee.getGetIdCallCount();
        this.result = this.unitOfWork.executeQuery((DatabaseQuery)this.conformedQuery);
        this.actualGetIdCallCount = Employee.getGetIdCallCount() - initialCount;
        this.unitOfWork.release();
    }

    @Override
    public void verify() {
        if (this.result == null && this.testCase != 1) {
            throw new TestErrorException("object existed in unit of work but not returned in query.");
        }
        if (this.result != null && this.testCase == 1) {
            throw new TestErrorException("object was deleted in unit of work but returned in query.");
        }
        if (this.actualGetIdCallCount != this.expectedGetIdCallCount) {
            throw new TestErrorException("The performance of find by primary key has changed.  Expected calls to getId: " + this.expectedGetIdCallCount + ".  Actual calls: " + this.actualGetIdCallCount + ".  As long as the algorithmic complexity does not change (linear/constant) this should be ok.");
        }
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.checkCacheByExactPrimaryKey;
    }
}

