/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class JPQLExceptionTest
extends JPQLTestCase {
    public EclipseLinkException expectedException;
    public EclipseLinkException caughtException;
    public ClassDescriptor oldDescriptor;

    public static JPQLExceptionTest recognitionExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.syntaxErrorAt(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("SELECT OBJECT(emp) FROW Employee emp");
        theTest.setName("Recognition Exception Test");
        return theTest;
    }

    public static JPQLExceptionTest missingSelectExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedToken(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("OBJECT(emp) FROM Employee emp");
        theTest.setName("Missing Select Exception Test");
        return theTest;
    }

    public static JPQLExceptionTest malformedEjbqlExceptionTest1() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedToken(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName == \"Fred\"");
        theTest.setName("Malformed EJBQL Exception Test1");
        return theTest;
    }

    public static JPQLExceptionTest malformedEjbqlExceptionTest2() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedEOF(null, (int)0, (int)0, null);
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" AND 1");
        theTest.setName("Malformed EJBQL Exception Test2");
        return theTest;
    }

    public static JPQLExceptionTest malformedEjbqlExceptionTest3() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedEOF(null, (int)0, (int)0, null);
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" OR \"Freda\"");
        theTest.setName("Malformed EJBQL Exception Test3");
        return theTest;
    }

    public static JPQLExceptionTest malformedEjbqlExceptionTest4() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedToken(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("SLEECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" OR \"Freda\"");
        theTest.setName("Malformed EJBQL Exception Test4");
        return theTest;
    }

    public static JPQLExceptionTest badAliasExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.aliasResolutionException(null, (int)0, (int)0, null);
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee employee WHERE emp.firstName = \"Fred\"");
        theTest.setName("Bad Alias Exception Test 2");
        return theTest;
    }

    public static JPQLExceptionTest noAliasWithWHEREAndParameterExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedToken(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("FROM Employee WHERE firstName = ?1");
        theTest.setName("No Alias With WHERE and Parameter Exception Test");
        return theTest;
    }

    public static JPQLExceptionTest generalExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.unexpectedToken(null, (int)0, (int)0, null, null);
        theTest.setEjbqlString("SELECT FROM EMPLOYEE emp");
        theTest.setName("General Exception test");
        return theTest;
    }

    public static JPQLExceptionTest classNotFoundExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.resolutionClassNotFoundException(null, null);
        theTest.setReferenceClass(Address.class);
        theTest.setEjbqlString("SELECT OBJECT(a) FROM AddressBean a WHERE a.city = \"Ottawa\"");
        theTest.setName("Class Not Found Exception test");
        return theTest;
    }

    public static JPQLExceptionTest aliasResolutionException() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.aliasResolutionException(null, (int)0, (int)0, null);
        theTest.setName("Bad Alias Exception test 1");
        theTest.setEjbqlString("SELECT OBJECT(nullRoot) FROM Employee emp WHERE emp.firstName = \"Fred\"");
        return theTest;
    }

    public static JPQLExceptionTest missingDescriptorExceptionTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.entityTypeNotFound2(null, (int)0, (int)0, null);
        theTest.setName("Missing Descriptor Exception test");
        theTest.setEjbqlString("SELECT OBJECT(i) FROM Integer i WHERE i.city = \"Ottawa\"");
        return theTest;
    }

    public static JPQLExceptionTest expressionNotSupportedTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.expressionNotSupported(null, null);
        theTest.setName("Expression Not Supported Exception test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.phoneNumbers IS EMPTY");
        return theTest;
    }

    public static JPQLExceptionTest memberOfNotSupportedTest() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.expectedException = JPQLException.expressionNotSupported(null, null);
        theTest.setName("MEMBER OF Not Supported Exception test");
        theTest.setEjbqlString("SELECT OBJECT(proj) FROM Employee emp, Project proj  WHERE  (proj.teamLeader MEMBER OF emp.manager.managedEmployees) AND (emp.lastName = \"Chan\")");
        return theTest;
    }

    public static void addTestsTo(TestSuite theSuite) {
        theSuite.addTest((Test)JPQLExceptionTest.generalExceptionTest());
        theSuite.addTest((Test)JPQLExceptionTest.missingDescriptorExceptionTest());
        theSuite.addTest((Test)JPQLExceptionTest.aliasResolutionException());
        theSuite.addTest((Test)JPQLExceptionTest.recognitionExceptionTest());
        theSuite.addTest((Test)JPQLExceptionTest.malformedEjbqlExceptionTest1());
        theSuite.addTest((Test)JPQLExceptionTest.malformedEjbqlExceptionTest2());
        theSuite.addTest((Test)JPQLExceptionTest.malformedEjbqlExceptionTest3());
        theSuite.addTest((Test)JPQLExceptionTest.malformedEjbqlExceptionTest4());
        theSuite.addTest((Test)JPQLExceptionTest.missingSelectExceptionTest());
        theSuite.addTest((Test)JPQLExceptionTest.badAliasExceptionTest());
        theSuite.addTest((Test)JPQLExceptionTest.noAliasWithWHEREAndParameterExceptionTest());
    }

    @Override
    public void setup() {
        super.setup();
    }

    @Override
    public void test() {
        try {
            this.getSession().logMessage("Running EJBQL -> " + this.getEjbqlString());
            this.setReturnedObjects(this.getSession().executeQuery((DatabaseQuery)this.getQuery()));
        }
        catch (EclipseLinkException tle) {
            this.caughtException = tle;
        }
        catch (Exception e) {
            this.caughtException = new TestErrorException(e.getMessage());
        }
    }

    @Override
    public void verify() {
        JPQLException internalException;
        Vector exceptions;
        if (this.caughtException == null) {
            throw new TestErrorException("The proper exception was not thrown:" + Helper.cr() + "caught exception was null! \n\n[EXPECTING] " + this.expectedException);
        }
        if (this.caughtException instanceof JPQLException) {
            return;
        }
        if (this.caughtException.getErrorCode() == this.expectedException.getErrorCode()) {
            return;
        }
        if (((Object)((Object)this.caughtException)).getClass() == JPQLException.class && (exceptions = (Vector)((JPQLException)this.caughtException).getInternalExceptions()).size() > 0 && (internalException = (JPQLException)exceptions.firstElement()).getErrorCode() == this.expectedException.getErrorCode()) {
            return;
        }
        throw new TestErrorException("The proper exception was not thrown:" + Helper.cr() + "[CAUGHT] " + this.caughtException + "\n\n[EXPECTING] " + this.expectedException);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public ObjectLevelReadQuery getQuery() {
        if (this.theQuery == null) {
            if (this.useReportQuery) {
                this.setQuery((ObjectLevelReadQuery)this.buildReportQuery());
            } else {
                this.setQuery((ObjectLevelReadQuery)new ReadAllQuery());
            }
            this.getQuery().setEJBQLString(this.getEjbqlString());
            this.getQuery().setReferenceClass(this.getReferenceClass());
        }
        return this.theQuery;
    }
}

