/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.toa;

import com.sun.corba.ee.impl.ior.ObjectKeyTemplateBase;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.oa.toa.TOA;
import com.sun.corba.ee.impl.oa.toa.TOAImpl;
import com.sun.corba.ee.impl.oa.toa.TransientObjectManager;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.omg.CORBA.ORB;

@ManagedObject
@Description(value="The Factory for the TOA (transient object adapter)")
@AMXMetadata(isSingleton=true)
public class TOAFactory
implements ObjectAdapterFactory {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private com.sun.corba.ee.spi.orb.ORB orb;
    private TOAImpl toa;
    private Map<String, TOAImpl> codebaseToTOA;
    private TransientObjectManager tom;

    @ManagedAttribute
    @Description(value="The default TOA used only for dispatch, not objref creation")
    private TOAImpl getDefaultTOA() {
        return this.toa;
    }

    @ManagedAttribute
    @Description(value="The map from Codebase to TOA")
    private synchronized Map<String, TOAImpl> getCodebaseMap() {
        return new HashMap<String, TOAImpl>(this.codebaseToTOA);
    }

    @Override
    public ObjectAdapter find(ObjectAdapterId oaid) {
        if (oaid.equals(ObjectKeyTemplateBase.JIDL_OAID)) {
            return this.getTOA();
        }
        throw wrapper.badToaOaid();
    }

    @Override
    public void init(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.tom = new TransientObjectManager(orb);
        this.codebaseToTOA = new HashMap<String, TOAImpl>();
        orb.mom().registerAtRoot((Object)this);
    }

    @Override
    public void shutdown(boolean waitForCompletion) {
        if (Util.getInstance() != null) {
            Util.getInstance().unregisterTargetsForORB((ORB)this.orb);
        }
    }

    public synchronized TOA getTOA(String codebase) {
        TOAImpl myToa = this.codebaseToTOA.get(codebase);
        if (myToa == null) {
            myToa = new TOAImpl(this.orb, this.tom, codebase);
            this.codebaseToTOA.put(codebase, myToa);
        }
        return myToa;
    }

    public synchronized TOA getTOA() {
        if (this.toa == null) {
            this.toa = new TOAImpl(this.orb, this.tom, null);
        }
        return this.toa;
    }

    @Override
    public com.sun.corba.ee.spi.orb.ORB getORB() {
        return this.orb;
    }
}

