/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableCreator {
    public static boolean CHECK_EXISTENCE = true;
    protected List<TableDefinition> tableDefinitions;
    protected String name;
    protected boolean ignoreDatabaseException;

    public TableCreator() {
        this(new ArrayList<TableDefinition>());
    }

    public TableCreator(List<TableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.add(tableDefinition);
    }

    public void addTableDefinitions(Collection<TableDefinition> tableDefs) {
        this.tableDefinitions.addAll(tableDefs);
    }

    public void createConstraints(DatabaseSession session) {
        this.createConstraints(session, new SchemaManager(session));
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.createConstraints(session, schemaManager, true);
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.createConstraints(this.getTableDefinitions(), session, schemaManager, build);
    }

    public void createConstraints(List<TableDefinition> tables, DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : tables) {
            try {
                schemaManager.createUniqueConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        for (TableDefinition table : tables) {
            try {
                schemaManager.createForeignConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public void createTables(DatabaseSession session) {
        this.createTables(session, new SchemaManager(session));
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager) {
        this.createTables(session, schemaManager, true);
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.createTables(session, schemaManager, build, true, true, true);
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager, boolean build, boolean check, boolean createSequenceTables, boolean createSequences) {
        this.buildConstraints(schemaManager, build);
        String sequenceTableName = this.getSequenceTableName(session);
        ArrayList<TableDefinition> missingTables = new ArrayList<TableDefinition>();
        for (TableDefinition table : this.getTableDefinitions()) {
            if (table.getName().equals(sequenceTableName)) continue;
            boolean alreadyExists = false;
            if (check && CHECK_EXISTENCE && schemaManager.shouldWriteToDatabase()) {
                alreadyExists = schemaManager.checkTableExists(table);
            }
            if (alreadyExists) continue;
            missingTables.add(table);
            try {
                schemaManager.createObject(table);
                session.getSessionLog().log(1, "ddl", "default_tables_created", (Object)table.getFullName());
            }
            catch (DatabaseException ex) {
                session.getSessionLog().log(1, "ddl", "default_tables_already_existed", (Object)table.getFullName());
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        this.createConstraints(missingTables, session, schemaManager, false);
        schemaManager.createOrReplaceSequences(createSequenceTables, createSequences);
    }

    public void dropConstraints(DatabaseSession session) {
        this.dropConstraints(session, new SchemaManager(session));
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.dropConstraints(session, schemaManager, true);
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : this.getTableDefinitions()) {
            try {
                schemaManager.dropConstraints(table);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public void dropTables(DatabaseSession session) {
        this.dropTables(session, new SchemaManager(session));
    }

    public void dropTables(DatabaseSession session, SchemaManager schemaManager) {
        this.dropTables(session, schemaManager, true);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        boolean shouldLogExceptionStackTrace = session.getSessionLog().shouldLogExceptionStackTrace();
        int level = session.getSessionLog().getLevel();
        if (shouldLogExceptionStackTrace) {
            session.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        if (level > 3) {
            session.getSessionLog().setLevel(7);
        }
        try {
            this.dropConstraints(session, schemaManager, false);
            String sequenceTableName = this.getSequenceTableName(session);
            List<TableDefinition> tables = this.getTableDefinitions();
            int trys = 1;
            if (!SchemaManager.FORCE_DROP) {
                if (trys <= 0) return;
                if (tables.isEmpty()) {
                    return;
                }
            } else {
                trys = 5;
                if (true) {
                    if (trys <= 0) return;
                    if (tables.isEmpty()) return;
                }
            }
            do {
                --trys;
                ArrayList<TableDefinition> failed = new ArrayList<TableDefinition>();
                for (TableDefinition table : tables) {
                    if (table.getName().equals(sequenceTableName)) continue;
                    try {
                        schemaManager.dropObject(table);
                    }
                    catch (DatabaseException exception) {
                        failed.add(table);
                        if (this.shouldIgnoreDatabaseException()) continue;
                        throw exception;
                    }
                }
                tables = failed;
                if (trys <= 0) return;
            } while (!tables.isEmpty());
            return;
        }
        finally {
            if (shouldLogExceptionStackTrace) {
                session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
            if (level > 3) {
                session.getSessionLog().setLevel(level);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession session) {
        this.replaceTables(session, new SchemaManager(session));
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager) {
        this.replaceTables(session, schemaManager, true, true);
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean createSequenceTables) {
        this.replaceTables(session, schemaManager, createSequenceTables, false);
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean createSequenceTables, boolean createSequences) {
        this.replaceTablesAndConstraints(schemaManager, session, createSequenceTables, createSequences);
    }

    protected void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session, boolean createSequenceTables, boolean createSequences) {
        this.buildConstraints(schemaManager, true);
        boolean ignore = this.shouldIgnoreDatabaseException();
        this.setIgnoreDatabaseException(true);
        try {
            this.dropTables(session, schemaManager, false);
        }
        finally {
            this.setIgnoreDatabaseException(ignore);
        }
        this.createTables(session, schemaManager, false, false, createSequenceTables, createSequences);
    }

    protected void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        this.replaceTables(session, schemaManager, false, false);
    }

    protected void buildConstraints(SchemaManager schemaManager, boolean build) {
        if (build) {
            for (TableDefinition table : this.getTableDefinitions()) {
                schemaManager.buildFieldTypes(table);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableDefinitions(Vector tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public boolean shouldIgnoreDatabaseException() {
        return this.ignoreDatabaseException;
    }

    public void setIgnoreDatabaseException(boolean ignoreDatabaseException) {
        this.ignoreDatabaseException = ignoreDatabaseException;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String sequenceTableName = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            sequenceTableName = ((TableSequence)sequence).getQualifiedTableName();
        }
        return sequenceTableName;
    }

    public void extendTables(DatabaseSession session, SchemaManager schemaManager) {
        this.extendTablesAndConstraints(schemaManager, session);
        schemaManager.createOrReplaceSequences(true, true);
    }

    protected void extendTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        this.buildConstraints(schemaManager, true);
        boolean ignore = this.shouldIgnoreDatabaseException();
        this.setIgnoreDatabaseException(true);
        try {
            this.extendTables(session, schemaManager, false);
        }
        finally {
            this.setIgnoreDatabaseException(ignore);
        }
    }

    public void extendTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        String sequenceTableName = this.getSequenceTableName(session);
        for (TableDefinition table : this.getTableDefinitions()) {
            if (table.getName().equals(sequenceTableName)) continue;
            AbstractSession abstractSession = (AbstractSession)((Object)session);
            boolean alreadyExists = false;
            if (CHECK_EXISTENCE && schemaManager.shouldWriteToDatabase()) {
                alreadyExists = schemaManager.checkTableExists(table);
            }
            DatabaseException createTableException = null;
            if (!alreadyExists) {
                try {
                    schemaManager.createObject(table);
                    session.getSessionLog().log(1, "ddl", "default_tables_created", (Object)table.getFullName());
                }
                catch (DatabaseException exception) {
                    createTableException = exception;
                    alreadyExists = true;
                }
            }
            if (!alreadyExists) continue;
            String tableName = table.getTable() == null ? table.getName() : table.getTable().getName();
            boolean usesDelimiting = table.getTable() != null && table.getTable().shouldUseDelimiters();
            Vector columnInfo = null;
            columnInfo = abstractSession.getAccessor().getColumnInfo(null, null, tableName, null, abstractSession);
            if (!usesDelimiting && (columnInfo == null || columnInfo.isEmpty())) {
                tableName = tableName.toUpperCase();
                columnInfo = abstractSession.getAccessor().getColumnInfo(null, null, tableName, null, abstractSession);
                if (columnInfo == null || columnInfo.isEmpty()) {
                    tableName = tableName.toLowerCase();
                    columnInfo = abstractSession.getAccessor().getColumnInfo(null, null, tableName, null, abstractSession);
                }
            }
            if (columnInfo != null && !columnInfo.isEmpty()) {
                DatabasePlatform platform;
                HashMap<DatabaseField, DatabaseRecord> columns = new HashMap<DatabaseField, DatabaseRecord>(columnInfo.size());
                DatabaseField columnNameLookupField = new DatabaseField("COLUMN_NAME");
                DatabaseField schemaLookupField = new DatabaseField("TABLE_SCHEM");
                boolean schemaMatchFound = false;
                String qualifier = table.getQualifier();
                if (!(qualifier != null && qualifier.length() != 0 || (qualifier = session.getDatasourcePlatform().getTableQualifier()) != null && qualifier.length() != 0 || (qualifier = session.getLogin().getUserName()) != null && qualifier.length() != 0 || !(platform = session.getPlatform()).supportsConnectionUserName())) {
                    qualifier = platform.getConnectionUserName();
                }
                boolean checkSchema = qualifier != null && qualifier.length() > 0;
                for (DatabaseRecord record : columnInfo) {
                    String fieldName = (String)record.get(columnNameLookupField);
                    if (fieldName == null || fieldName.length() <= 0) continue;
                    DatabaseField column = new DatabaseField(fieldName);
                    if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        column.useUpperCaseForComparisons(true);
                    }
                    String schema = (String)record.get(schemaLookupField);
                    if (schemaMatchFound) {
                        if (!qualifier.equalsIgnoreCase(schema)) continue;
                        columns.put(column, record);
                        continue;
                    }
                    if (checkSchema && qualifier.equalsIgnoreCase(schema)) {
                        schemaMatchFound = true;
                        columns.clear();
                    }
                    columns.put(column, record);
                }
                for (FieldDefinition fieldDef : table.getFields()) {
                    DatabaseField dbField = fieldDef.getDatabaseField();
                    if (dbField == null) {
                        dbField = new DatabaseField(fieldDef.getName());
                    }
                    if (columns.get(dbField) != null) continue;
                    try {
                        table.addFieldOnDatabase(abstractSession, fieldDef);
                    }
                    catch (DatabaseException addFieldEx) {
                        session.getSessionLog().log(1, "ddl", "cannot_add_field_to_table", (Object)dbField.getName(), (Object)table.getFullName(), (Object)addFieldEx.getMessage());
                        if (this.shouldIgnoreDatabaseException()) continue;
                        throw addFieldEx;
                    }
                }
                continue;
            }
            if (createTableException == null) continue;
            session.getSessionLog().log(1, "ddl", "cannot_create_table", (Object)table.getFullName(), (Object)createTableException.getMessage());
            if (this.shouldIgnoreDatabaseException()) continue;
            throw createTableException;
        }
        this.createConstraints(session, schemaManager, false);
        schemaManager.createSequences();
    }
}

