/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Customer;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class UnitOfWorkRevertAndResumeTest
extends AutoVerifyTestCase {
    public Customer customer;
    public SalesPerson sales = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.sales = (SalesPerson)uow.readObject(SalesPerson.class);
        this.sales.getCustomers().add(new Customer());
        uow.revertAndResume();
        this.customer = new Customer();
        this.customer.setName("Andy Fellows");
        this.customer = (Customer)uow.registerObject((Object)this.customer);
        this.sales.getCustomers().add(this.customer);
    }

    public void verify() {
        if (!this.customer.getSalespeople().contains(this.sales)) {
            throw new TestErrorException("Failed to set the backPointer information, after revertAndResume");
        }
    }
}

