/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CursoredStreamDistinctTest
extends TestCase {
    public int count;

    public CursoredStreamDistinctTest() {
        this.setDescription("Verify the size works correctly with distinct when single field is queried");
    }

    public void setup() {
        if (this.getSession().getPlatform().isAccess()) {
            throw new TestWarningException("Access does not support distinct in counts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ExpressionBuilder eb = new ExpressionBuilder();
        ReportQuery q = new ReportQuery(Employee.class, eb);
        q.addAttribute("Name", eb.get("lastName"));
        q.useDistinct();
        q.setSelectionCriteria(eb.get("salary").greaterThan(1));
        q.useCursoredStream();
        try (CursoredStream cs = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)q);){
            cs.read(1);
            this.count = cs.size();
        }
    }

    public void verify() {
        ExpressionBuilder eb = new ExpressionBuilder();
        ReportQuery q = new ReportQuery(Employee.class, eb);
        q.addAttribute("Name", eb.get("lastName"));
        q.useDistinct();
        q.setSelectionCriteria(eb.get("salary").greaterThan(1));
        if (this.count != ((Vector)this.getSession().executeQuery((DatabaseQuery)q)).size()) {
            throw new TestErrorException("Size is incorrect, when using distinct on a single field query");
        }
    }
}

