/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class LargeRowFetchTest
extends PerformanceComparisonTestCase {
    protected Connection connection;
    protected String sql;

    public LargeRowFetchTest() {
        this.setName("Default row fetch vs set row fetch (50, 100 objects) PerformanceComparisonTest");
        this.setDescription("Compares the performance between using default and set row fetch, query 100 rows, row fetch set to 50.");
        this.addSetRowFetch();
    }

    public void setup() throws Exception {
        this.connection = (Connection)((AbstractSession)this.getSession()).getAccessor().getDatasourceConnection();
        this.sql = "SELECT * FROM EMPLOYEE";
    }

    public void test() throws Exception {
        PreparedStatement statement = this.connection.prepareStatement(this.sql);
        ResultSet result = statement.executeQuery();
        int size = result.getMetaData().getColumnCount();
        Vector rows = new Vector();
        while (result.next()) {
            Vector<Object> row = new Vector<Object>(size);
            for (int column = 1; column <= size; ++column) {
                row.add(result.getObject(column));
            }
            rows.add(row);
        }
        result.close();
        statement.close();
    }

    public void addSetRowFetch() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                PreparedStatement statement = LargeRowFetchTest.this.connection.prepareStatement(LargeRowFetchTest.this.sql);
                statement.setFetchSize(50);
                ResultSet result = statement.executeQuery();
                int size = result.getMetaData().getColumnCount();
                Vector rows = new Vector();
                while (result.next()) {
                    Vector<Object> row = new Vector<Object>(size);
                    for (int column = 1; column <= size; ++column) {
                        row.add(result.getObject(column));
                    }
                    rows.add(row);
                }
                result.close();
                statement.close();
            }
        };
        test.setName("SetRowFetchTest");
        test.setAllowableDecrease(10.0);
        this.addTest((TestCase)test);
    }
}

