/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class OrderByRandomTest
extends AutoVerifyTestCase {
    protected Vector results = null;

    public OrderByRandomTest() {
        this.setDescription("Test order by with Random");
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test does not work on the this platform");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ExpressionBuilder eb = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, eb);
        rq.addAttribute("firstName");
        rq.addAttribute("lastName");
        Expression exp = eb.getFunction("dbms_random.value");
        exp.setSelectIfOrderedBy(false);
        rq.addOrdering(exp.ascending());
        rq.setSelectionCriteria(eb.anyOf("projects").get("teamLeader").isNull());
        this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)rq);
    }

    public void verify() {
        if (this.results.size() != 6) {
            throw new TestErrorException("The incorrect number of results was returned from a ReportQuery that included a random function.");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

