/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.Golfer;
import org.eclipse.persistence.testing.models.jpa.advanced.GolferPK;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.advanced.PartnerLink;
import org.eclipse.persistence.testing.models.jpa.advanced.PartnerLinkPK;
import org.eclipse.persistence.testing.models.jpa.advanced.Vegetable;
import org.eclipse.persistence.testing.models.jpa.advanced.VegetablePK;
import org.eclipse.persistence.testing.models.jpa.advanced.Woman;
import org.eclipse.persistence.testing.models.jpa.advanced.WorldRank;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.SimpleEntity;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.SimpleLanguage;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.SimpleNature;
import org.eclipse.persistence.testing.tests.jpa.advanced.PostAcquireExclusiveConnectionSqlExecutorListener;

public class AdvancedJunitTest
extends JUnitTestCase {
    public AdvancedJunitTest() {
    }

    public AdvancedJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AdvancedJunitTest");
        suite.addTest((Test)new AdvancedJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedJunitTest("testGF1818"));
        suite.addTest((Test)new AdvancedJunitTest("testEL254937"));
        suite.addTest((Test)new AdvancedJunitTest("testGF1894"));
        suite.addTest((Test)new AdvancedJunitTest("testGF894"));
        suite.addTest((Test)new AdvancedJunitTest("testManAndWoman"));
        suite.addTest((Test)new AdvancedJunitTest("testStringArrayField"));
        suite.addTest((Test)new AdvancedJunitTest("testCreateDerivedPKFromPKValues"));
        suite.addTest((Test)new AdvancedJunitTest("testElementCollectionClear"));
        suite.addTest((Test)new AdvancedJunitTest("testElementCollectionEntityMapKeyRemove"));
        suite.addTest((Test)new AdvancedJunitTest("testSwitchBatchDuringSessionEvent"));
        suite.addTest((Test)new AdvancedJunitTest("testCoalesceJPQLQueryWithNullParameterValue"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testGF1818() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vegetable vegetable = new Vegetable();
            vegetable.setId(new VegetablePK("Carrot", "Orange"));
            vegetable.setCost(2.09);
            em.persist((Object)vegetable);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testEL254937() {
        if (!AdvancedJunitTest.isOnServer()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            LargeProject lp1 = new LargeProject();
            lp1.setName("one");
            em.persist((Object)lp1);
            this.commitTransaction(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.remove(em.find(LargeProject.class, (Object)lp1.getId()));
            em.flush();
            JpaEntityManager eclipselinkEm = (JpaEntityManager)em.getDelegate();
            RepeatableWriteUnitOfWork uow = (RepeatableWriteUnitOfWork)eclipselinkEm.getActiveSession();
            uow.issueSQLbeforeCompletion();
            uow.setShouldTerminateTransaction(true);
            uow.commitTransaction();
            uow.mergeClonesAfterCompletion();
            em = this.createEntityManager();
            LargeProject cachedLargeProject = (LargeProject)em.find(LargeProject.class, (Object)lp1.getId());
            this.closeEntityManager(em);
            AdvancedJunitTest.assertTrue((String)"Entity removed during flush was not removed from the shared cache on commit", (cachedLargeProject == null ? 1 : 0) != 0);
        }
    }

    public void testGF1894() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Guy");
        emp.setLastName("Pelletier");
        Address address = new Address();
        address.setCity("College Town");
        emp.setAddress(address);
        try {
            Employee empClone = (Employee)em.merge((Object)emp);
            AdvancedJunitTest.assertNotNull((String)"The id field for the merged new employee object was not generated.", (Object)empClone.getId());
            this.commitTransaction(em);
            Employee empFromDB = (Employee)em.find(Employee.class, (Object)empClone.getId());
            AdvancedJunitTest.assertNotNull((String)"The version locking field for the merged new employee object was not updated after commit.", (Object)empFromDB.getVersion());
            this.beginTransaction(em);
            Employee empClone2 = (Employee)em.merge((Object)empFromDB);
            AdvancedJunitTest.assertTrue((String)"The id field on a existing merged employee object was modified on a subsequent merge.", (boolean)empFromDB.getId().equals(empClone2.getId()));
            this.commitTransaction(em);
        }
        catch (OptimisticLockException e) {
            AdvancedJunitTest.fail((String)"An optimistic locking exception was caught on the merge of a new object. An insert should of occurred instead.");
        }
        this.closeEntityManager(em);
    }

    public void testGF894() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            int i = 0;
            while (true) {
                GolferPK golferPK;
                Golfer golfer;
                if ((golfer = (Golfer)em.find(Golfer.class, (Object)(golferPK = new GolferPK(i)))) == null) {
                    golfer = new Golfer();
                    golfer.setGolferPK(golferPK);
                    WorldRank worldRank = new WorldRank();
                    worldRank.setId(i);
                    golfer.setWorldRank(worldRank);
                    em.persist((Object)worldRank);
                    em.persist((Object)golfer);
                    this.commitTransaction(em);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testManAndWoman() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartnerLink pLink1 = new PartnerLink();
            pLink1.setMan(new Man());
            em.persist((Object)pLink1);
            PartnerLink pLink2 = new PartnerLink();
            pLink2.setWoman(new Woman());
            em.persist((Object)pLink2);
            PartnerLink pLink3 = new PartnerLink();
            pLink3.setMan(new Man());
            pLink3.setWoman(new Woman());
            em.persist((Object)pLink3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDerivedPKFromPKValues() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartnerLink pLink3 = new PartnerLink();
            pLink3.setMan(new Man());
            pLink3.setWoman(new Woman());
            em.persist((Object)pLink3);
            this.commitTransaction(em);
            ClassDescriptor descriptor = AdvancedJunitTest.getServerSession().getClassDescriptor(PartnerLink.class);
            Object pks = descriptor.getObjectBuilder().extractPrimaryKeyFromObject((Object)pLink3, (AbstractSession)AdvancedJunitTest.getServerSession());
            PartnerLinkPK createdPK = (PartnerLinkPK)descriptor.getCMPPolicy().createPrimaryKeyInstanceFromId(pks, (AbstractSession)AdvancedJunitTest.getServerSession());
            PartnerLinkPK usedPk = new PartnerLinkPK(pLink3.getManId().intValue(), pLink3.getWomanId());
            AdvancedJunitTest.assertTrue((String)"PK's do not match.", (boolean)usedPk.equals((Object)createdPK));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testStringArrayField() {
        Vegetable vegetable;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        VegetablePK pk = new VegetablePK("Tomato", "Red");
        Object[] tags = new String[]{"California", "XE"};
        try {
            vegetable = new Vegetable();
            vegetable.setId(pk);
            vegetable.setCost(2.09);
            vegetable.setTags((String[])tags);
            em.persist((Object)vegetable);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            vegetable = (Vegetable)em.find(Vegetable.class, (Object)pk);
            this.commitTransaction(em);
            AdvancedJunitTest.assertNotNull((Object)vegetable);
            AdvancedJunitTest.assertTrue((boolean)Arrays.equals(tags, vegetable.getTags()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testElementCollectionClear() {
        SimpleEntity se;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            se = new SimpleEntity();
            se.setId(101L);
            se.setDescription("Element Collection Clear Test Record");
            ArrayList<String> nature = new ArrayList<String>();
            nature.add(SimpleNature.PERSONALITY[0]);
            nature.add(SimpleNature.PERSONALITY[1]);
            nature.add(SimpleNature.PERSONALITY[2]);
            nature.add(SimpleNature.PERSONALITY[3]);
            nature.add(SimpleNature.PERSONALITY[4]);
            nature.add(SimpleNature.PERSONALITY[5]);
            se.setSimpleNature(nature);
            em.persist((Object)se);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        try {
            se = (SimpleEntity)em.find(SimpleEntity.class, (Object)101L);
            em.clear();
            this.closeEntityManager(em);
            se.getSimpleNature().clear();
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.merge((Object)se);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            se = (SimpleEntity)em.find(SimpleEntity.class, (Object)101L);
            Collection natureList = se.getSimpleNature();
            int count = 0;
            for (String nature : natureList) {
                ++count;
            }
            Assert.assertEquals((String)"All entries of collection have not been removed from database for ElementCollection Test.", (int)0, (int)count);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testElementCollectionEntityMapKeyRemove() {
        SimpleEntity se;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            se = new SimpleEntity();
            se.setId(102L);
            se.setDescription("Element Collection Entity MapKey Remove Test Record");
            SimpleLanguage slen = new SimpleLanguage();
            slen.setCode("EN");
            slen.setDescription("English");
            SimpleLanguage slfr = new SimpleLanguage();
            slfr.setCode("FR");
            slfr.setDescription("French");
            se.getSimpleLanguage().put(slen, "Modest");
            se.getSimpleLanguage().put(slfr, "Modeste");
            em.persist((Object)slen);
            em.persist((Object)slfr);
            em.persist((Object)se);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        se = null;
        SimpleLanguage slfr = null;
        try {
            this.beginTransaction(em);
            se = (SimpleEntity)em.find(SimpleEntity.class, (Object)102L);
            slfr = (SimpleLanguage)em.find(SimpleLanguage.class, (Object)"FR");
            se.getSimpleLanguage().remove(slfr);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            slfr = (SimpleLanguage)em.find(SimpleLanguage.class, (Object)"FR");
            Assert.assertNotSame((String)"Entity used as key in Collection Map has been deleted along with data in collection table on remove.", null, (Object)slfr);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSwitchBatchDuringSessionEvent() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vegetable vegetable = (Vegetable)em.find(Vegetable.class, (Object)new VegetablePK("Potato", "Yellow"));
            if (null != vegetable) {
                em.remove((Object)vegetable);
                em.flush();
                this.commitTransaction(em);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.clearCache();
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        DatabasePlatform platform = AdvancedJunitTest.getServerSession().getPlatform();
        boolean usesBatchWriting = platform.usesBatchWriting();
        boolean usesJDBCBatchWriting = platform.usesJDBCBatchWriting();
        boolean usesExternalConnectionPooling = AdvancedJunitTest.getServerSession().getLogin().shouldUseExternalConnectionPooling();
        boolean usesExternalTransactionController = AdvancedJunitTest.getServerSession().getLogin().shouldUseExternalTransactionController();
        PostAcquireExclusiveConnectionSqlExecutorListener listener = new PostAcquireExclusiveConnectionSqlExecutorListener();
        try {
            AdvancedJunitTest.getServerSession().getLogin().useExternalConnectionPooling();
            AdvancedJunitTest.getServerSession().getLogin().useExternalTransactionController();
            platform.setUsesBatchWriting(true);
            platform.setUsesJDBCBatchWriting(true);
            em.setProperty("eclipselink.jdbc.exclusive-connection.mode", (Object)"Always");
            AdvancedJunitTest.getServerSession().getEventManager().addListener((SessionEventListener)listener);
            this.beginTransaction(em);
            em.setFlushMode(FlushModeType.COMMIT);
            Vegetable vegetable = (Vegetable)em.find(Vegetable.class, (Object)new VegetablePK("Potato", "Yellow"));
            if (vegetable == null) {
                vegetable = new Vegetable();
            }
            vegetable.setId(new VegetablePK("Potato", "Yellow"));
            vegetable.setCost(1.1);
            em.persist((Object)vegetable);
            this.commitTransaction(em);
        }
        catch (RollbackException r) {
            AdvancedJunitTest.fail((String)("RollbackException exception occurred : " + r.getMessage()));
        }
        finally {
            AdvancedJunitTest.getServerSession().getEventManager().removeListener((SessionEventListener)listener);
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            platform.setUsesBatchWriting(usesBatchWriting);
            platform.setUsesJDBCBatchWriting(usesJDBCBatchWriting);
            if (!usesExternalConnectionPooling) {
                AdvancedJunitTest.getServerSession().getLogin().dontUseExternalConnectionPooling();
            }
            if (!usesExternalTransactionController) {
                AdvancedJunitTest.getServerSession().getLogin().dontUseExternalTransactionController();
            }
            this.clearCache();
            this.closeEntityManager(em);
        }
    }

    public void testCoalesceJPQLQueryWithNullParameterValue() {
        Employee emp1;
        EntityManager em = this.createEntityManager();
        Employee emp2 = null;
        try {
            this.beginTransaction(em);
            emp1 = new Employee();
            emp1.setFirstName("Per");
            emp1.setLastName("Johanssen");
            emp1.setSalary(100000);
            em.persist((Object)emp1);
            emp2 = new Employee();
            emp2.setFirstName("Kalle");
            emp2.setLastName("Johanssen");
            emp2.setSalary(999999);
            em.persist((Object)emp2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.clearCache();
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            String jpql = "select count(1) from Employee e where e.lastName = 'Johanssen' and e.salary = coalesce(e.salary, :sal)";
            Query query = em.createQuery(jpql);
            query = query.setParameter("sal", null);
            Long result = (Long)query.getSingleResult();
            AdvancedJunitTest.assertNotNull((String)"Query result should be non-null", (Object)result);
            AdvancedJunitTest.assertEquals((String)"Incorrect query results", (Object)new Long(2L), (Object)result);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.beginTransaction(em);
            emp1 = (Employee)em.find(Employee.class, (Object)emp1.getId());
            if (emp1 != null) {
                em.remove((Object)emp1);
            }
            if ((emp2 = (Employee)em.find(Employee.class, (Object)emp2.getId())) != null) {
                em.remove((Object)emp2);
            }
            this.commitTransaction(em);
            this.clearCache();
            this.closeEntityManager(em);
        }
    }
}

