/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_CommitFail_TestCase
extends AutoVerifyTestCase {
    public EclipseLinkException exception = null;
    public UnitOfWorkImpl uow = null;

    public void test() {
        this.uow = new UnitOfWorkImpl((AbstractSession)this.getSession(), null){
            int beginCount;
            {
                this.beginCount = 0;
            }

            public void commitTransaction() throws DatabaseException {
                if (this.beginCount == 1) {
                    throw DatabaseException.databaseAccessorNotConnected();
                }
                --this.beginCount;
                this.getParent().commitTransaction();
            }

            public void beginTransaction() throws DatabaseException {
                ++this.beginCount;
                this.getParent().beginTransaction();
            }
        };
        Employee employee = new Employee();
        employee = (Employee)this.uow.registerObject((Object)employee);
        employee.setFirstName("Stephen");
        employee.setLastName("McRitchie");
        this.uow.writeChanges();
        try {
            this.uow.commit();
        }
        catch (EclipseLinkException e) {
            this.exception = e;
        }
    }

    public void verify() {
        if (this.exception == null || this.exception.getErrorCode() != 4005) {
            throw new TestErrorException("UnitOfWorkImpl commit did not throw original database exception and instead threw :" + (Object)((Object)this.exception));
        }
        if (this.uow.getLifecycle() == 2) {
            throw new TestErrorException("UnitOfWorkImpl's getLifecycle still shows status as CommitTransactionPending after commit");
        }
    }
}

