/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.writing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.models.performance.toplink.PhoneNumber;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class ComplexUpdateEmployeeUnitOfWorkTest
extends PerformanceTest {
    protected Employee employee;
    protected Employee manager;
    protected PhoneNumber phone;
    protected boolean promotion = true;

    public ComplexUpdateEmployeeUnitOfWorkTest() {
        this.setDescription("This tests the performance of unit of work updates.");
    }

    @Override
    public void setup() {
        super.setup();
        this.allObjects = this.getSession().readAllObjects(Employee.class);
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
        this.manager = (Employee)this.employee.getManager();
        this.promotion = true;
    }

    @Override
    public void test() throws Exception {
        super.test();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject((Object)this.employee);
        if (this.promotion) {
            Employee manager = (Employee)employee.getManager();
            employee.setManager(manager.getManager());
            employee.addManagedEmployee(manager);
            employee.getAddress().setCity("Toronto");
            this.phone = new PhoneNumber();
            this.phone.setType("Cellphone");
            this.phone.setAreaCode("416");
            this.phone.setNumber("7921771");
            employee.addPhoneNumber(this.phone);
            employee.setSalary(employee.getSalary() + 100);
        } else {
            Employee manager = (Employee)uow.readObject((Object)this.manager);
            employee.removeManagedEmployee(manager);
            employee.setManager(manager);
            employee.getAddress().setCity("Ottawa");
            PhoneNumber phone = (PhoneNumber)uow.readObject((Object)this.phone);
            employee.removePhoneNumber(phone);
            employee.setSalary(employee.getSalary() - 100);
        }
        uow.commit();
        this.promotion = !this.promotion;
    }

    @Override
    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject((Object)this.employee);
        if (!this.promotion) {
            Employee manager = (Employee)uow.readObject((Object)this.manager);
            employee.removeManagedEmployee(manager);
            employee.setManager(manager);
            employee.getAddress().setCity("Ottawa");
            PhoneNumber phone = (PhoneNumber)uow.readObject((Object)this.phone);
            employee.removePhoneNumber(phone);
            employee.setSalary(employee.getSalary() - 100);
        }
        uow.commit();
        this.promotion = true;
    }
}

