/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllStreamvsCursorTest
extends PerformanceComparisonTestCase {
    public ReadAllStreamvsCursorTest() {
        this.setDescription("This test compares the performance of cursored streams vs scrollable cursors.");
        this.addReadAllScrollableCursorTest();
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.useCursoredStream(1, 1);
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        for (int index = 0; index < 10; ++index) {
            if (!stream.hasMoreElements()) continue;
            stream.nextElement();
        }
        stream.close();
    }

    public void addReadAllScrollableCursorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.useScrollableCursor();
                ScrollableCursor cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
                for (int index = 0; index < 10; ++index) {
                    if (!cursor.hasNext()) continue;
                    cursor.next();
                }
                cursor.close();
            }
        };
        test.setName("ReadAllScrollableCursorTest");
        test.setAllowableDecrease(-90.0);
        this.addTest((TestCase)test);
    }
}

