/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.sequencing;

import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sequencing.TableSequence;

public class SampleStringSequencingPolicy
extends TableSequence {
    protected char min = (char)97;
    protected char max = (char)122;
    protected int num = this.max - this.min + 1;

    public SampleStringSequencingPolicy(String name, int size) {
        super(name, size);
        this.setPreallocationSize(size);
    }

    public SampleStringSequencingPolicy(String name, String tableName, int size) {
        super(name, tableName);
        this.setPreallocationSize(size);
    }

    protected Vector createVector(Number sequence, String seqName, int size) {
        long last = sequence.longValue();
        long first = last - (long)size + 1L;
        if (first < 0L) {
            throw ValidationException.sequenceSetupIncorrectly((String)seqName);
        }
        Vector<String> sequencesForName = new Vector<String>(size);
        for (long index = first; index <= last; ++index) {
            String seqValue = this.createString(index);
            sequencesForName.addElement(seqValue);
        }
        return sequencesForName;
    }

    protected String createString(long n) {
        int size = 24;
        char[] ch = new char[size];
        int count = 0;
        while (n > 0L) {
            int i = (int)(n % (long)this.num);
            ch[size - ++count] = (char)(this.min + i);
            n /= (long)this.num;
        }
        String str = new String(ch, size - count, count);
        return str;
    }
}

