/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.interfaces;

import java.io.Serializable;
import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.testing.models.interfaces.Asset;
import org.eclipse.persistence.testing.models.interfaces.Computer;
import org.eclipse.persistence.testing.models.interfaces.Contact;
import org.eclipse.persistence.testing.models.interfaces.ContactHolder;
import org.eclipse.persistence.testing.models.interfaces.Email;
import org.eclipse.persistence.testing.models.interfaces.Phone;
import org.eclipse.persistence.testing.models.interfaces.Vehicle;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Employee
implements ContactHolder,
Serializable,
Cloneable {
    public Number id;
    public String name;
    public Contact contact;
    public ValueHolderInterface secondaryContact = new ValueHolder();
    public Asset asset1;
    public Asset asset2;

    public static void addToDescriptor(ClassDescriptor des) {
        AggregateObjectMapping map = (AggregateObjectMapping)des.getMappingForAttributeName("asset2");
        map.addFieldNameTranslation("INT_EMP.ASSET2_TYPE", "INT_EMP.ASSET_TYPE");
    }

    @Override
    public Object clone() {
        Employee clone = new Employee();
        clone.id = this.id;
        clone.name = this.name;
        clone.contact = this.contact;
        clone.asset1 = (Asset)this.asset1.clone();
        clone.asset2 = (Asset)this.asset2.clone();
        clone.secondaryContact = this.secondaryContact;
        return clone;
    }

    public static Employee example1() {
        Employee example = new Employee();
        example.setName("Betty");
        example.setContact(Phone.example1());
        example.getContact().setHolder(example);
        example.asset1 = new Asset();
        example.asset1.setAsset(Computer.example1());
        example.asset2 = new Asset();
        example.asset2.setAsset(Computer.example2());
        example.setSecondaryContact(Phone.example2());
        return example;
    }

    public static Employee example2() {
        Employee example = new Employee();
        example.setName("Chris");
        example.setContact(Phone.example1());
        example.getContact().setHolder(example);
        example.asset1 = new Asset();
        example.asset1.asset = Vehicle.example1();
        example.asset2 = new Asset();
        example.asset2.asset = Computer.example3();
        example.setSecondaryContact(Email.example3());
        return example;
    }

    public static Employee example3() {
        Employee example = new Employee();
        example.setName("Jude");
        example.setContact(Email.example2());
        example.getContact().setHolder(example);
        example.asset1 = new Asset();
        example.asset1.asset = Vehicle.example2();
        example.asset2 = new Asset();
        example.asset2.asset = Vehicle.example3();
        return example;
    }

    public static Employee example4() {
        Employee example = new Employee();
        example.setName("Brendan");
        example.setContact(null);
        example.asset1 = new Asset();
        example.asset1.asset = Vehicle.example2();
        example.asset2 = new Asset();
        example.asset2.asset = Vehicle.example3();
        return example;
    }

    @Override
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public Number getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Contact getSecondaryContact() {
        return (Contact)this.secondaryContact.getValue();
    }

    @Override
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @Override
    public void setId(Number id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSecondaryContact(Contact aContact) {
        this.secondaryContact.setValue((Object)aContact);
    }

    public static TableDefinition tableDefinition() {
        TableDefinition table = new TableDefinition();
        table.setName("INT_EMP");
        table.addField("ID", BigDecimal.class, 15);
        table.addField("NAME", String.class, 30);
        table.addField("CON_ID", BigDecimal.class, 15);
        table.addField("CONTACT_TYPE", Float.class, 5);
        table.addField("ASSET_ID", BigDecimal.class, 15);
        table.addField("ASSET_TYPE", String.class, 5);
        table.addField("ASSET2_ID", BigDecimal.class, 15);
        table.addField("ASSET2_TYPE", String.class, 5);
        table.addField("SEC_CON_ID", BigDecimal.class, 15);
        table.addField("SEC_CONTACT_TYPE", Float.class, 5);
        return table;
    }

    public String toString() {
        return this.getName();
    }
}

