/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.insurance;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.insurance.InsuranceProject;
import org.eclipse.persistence.testing.models.insurance.InsuranceTableCreator;
import org.eclipse.persistence.testing.models.insurance.Phone;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class InsuranceSystem
extends TestSystem {
    public void createTables(DatabaseSession session) {
        if (!SchemaManager.FAST_TABLE_CREATOR) {
            try {
                if (session.getPlatform().isMySQL()) {
                    session.executeNonSelectingCall((Call)new SQLCall("SET foreign_key_checks = 0"));
                }
                session.executeNonSelectingCall((Call)new SQLCall("drop table CHILDNAM"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table INS_ADDR"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table INS_PHONE"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table VHCL_POL"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table VHCL_CLM"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table CLAIM"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table POLICY"));
                session.executeNonSelectingCall((Call)new SQLCall("drop table HOLDER"));
            }
            catch (Exception e) {
                session.getSessionLog().logThrowable(6, (Throwable)e);
            }
            finally {
                if (session.getPlatform().isMySQL()) {
                    session.executeNonSelectingCall((Call)new SQLCall("SET foreign_key_checks = 1"));
                }
            }
        }
        new InsuranceTableCreator().replaceTables(session);
    }

    public static void modifyPhoneDescriptor(ClassDescriptor descriptor) {
        descriptor.descriptorIsAggregateCollection();
    }

    public static void modifyPolicyHolderDescriptor(ClassDescriptor descriptor) {
        AggregateCollectionMapping aggregatecollectionmapping = new AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("phones");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(false);
        aggregatecollectionmapping.setGetMethodName("getPhones");
        aggregatecollectionmapping.setSetMethodName("setPhones");
        aggregatecollectionmapping.setIsPrivateOwned(true);
        aggregatecollectionmapping.setReferenceClass(Phone.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("INS_PHONE.HOLDER_SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping);
    }

    public void populate(DatabaseSession session) throws DatabaseException {
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        PolicyHolder example = PolicyHolder.example1();
        PopulationManager.getDefaultManager().registerObject((Object)example, "example1");
        unitOfWork.registerObject((Object)example);
        example = PolicyHolder.example2();
        PopulationManager.getDefaultManager().registerObject((Object)example, "example2");
        unitOfWork.registerObject((Object)example);
        example = PolicyHolder.example3();
        PopulationManager.getDefaultManager().registerObject((Object)example, "example3");
        unitOfWork.registerObject((Object)example);
        example = PolicyHolder.example4();
        PopulationManager.getDefaultManager().registerObject((Object)example, "example4");
        unitOfWork.registerObject((Object)example);
        unitOfWork.commit();
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new InsuranceProject();
        }
        session.addDescriptors(this.project);
    }
}

