/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.NotThreadSafe;
import java.util.concurrent.TimeUnit;

public class AggregationOptions {
    private final Integer batchSize;
    private final Boolean allowDiskUse;
    private final OutputMode outputMode;
    private final long maxTimeMS;
    private final Boolean bypassDocumentValidation;

    AggregationOptions(Builder builder) {
        this.batchSize = builder.batchSize;
        this.allowDiskUse = builder.allowDiskUse;
        this.outputMode = builder.outputMode;
        this.maxTimeMS = builder.maxTimeMS;
        this.bypassDocumentValidation = builder.bypassDocumentValidation;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AggregationOptions{");
        sb.append("allowDiskUse=").append(this.allowDiskUse);
        sb.append(", batchSize=").append(this.batchSize);
        sb.append(", outputMode=").append((Object)this.outputMode);
        sb.append(", maxTimeMS=").append(this.maxTimeMS);
        sb.append(", bypassDocumentValidation=").append(this.bypassDocumentValidation);
        sb.append('}');
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder {
        private Integer batchSize;
        private Boolean allowDiskUse;
        private OutputMode outputMode = OutputMode.INLINE;
        private long maxTimeMS;
        private Boolean bypassDocumentValidation;

        private Builder() {
        }

        public Builder batchSize(Integer size) {
            this.batchSize = size;
            return this;
        }

        public Builder allowDiskUse(Boolean allowDiskUse) {
            this.allowDiskUse = allowDiskUse;
            return this;
        }

        public Builder outputMode(OutputMode mode) {
            this.outputMode = mode;
            return this;
        }

        public Builder maxTime(long maxTime, TimeUnit timeUnit) {
            this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
            return this;
        }

        public Builder bypassDocumentValidation(Boolean bypassDocumentValidation) {
            this.bypassDocumentValidation = bypassDocumentValidation;
            return this;
        }

        public AggregationOptions build() {
            return new AggregationOptions(this);
        }
    }

    public static enum OutputMode {
        INLINE,
        CURSOR;

    }
}

