/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseTypeTestableBase;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class PLSQLPackageType
extends DatabaseTypeTestableBase
implements CompositeDatabaseType,
DatabaseTypeVisitable {
    protected String packageName;
    protected String schema;
    protected List<PLSQLType> types;
    protected List<PLSQLCursorType> cursors;
    protected List<ProcedureType> procedures;
    protected List<FieldType> localVariables;

    public PLSQLPackageType() {
    }

    @Override
    public String getTypeName() {
        return "PACKAGE " + this.packageName;
    }

    public PLSQLPackageType(String packageName) {
        this.setPackageName(packageName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setTypeName(String typeName) {
        this.setPackageName(typeName);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<PLSQLType> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<PLSQLType>();
        }
        return this.types;
    }

    public void addType(PLSQLType type) {
        if (this.types == null) {
            this.types = new ArrayList<PLSQLType>();
        }
        if (!this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public List<PLSQLCursorType> getCursors() {
        if (this.cursors == null) {
            this.cursors = new ArrayList<PLSQLCursorType>();
        }
        return this.cursors;
    }

    public List<ProcedureType> getProcedures() {
        if (this.procedures == null) {
            this.procedures = new ArrayList<ProcedureType>();
        }
        return this.procedures;
    }

    public List<FieldType> getLocalVariables() {
        if (this.localVariables == null) {
            this.localVariables = new ArrayList<FieldType>();
        }
        return this.localVariables;
    }

    public void addCursor(PLSQLCursorType cursorType) {
        List<PLSQLCursorType> curs = this.getCursors();
        if (!curs.contains(cursorType)) {
            curs.add(cursorType);
        }
    }

    public void addProcedure(ProcedureType procedureType) {
        List<ProcedureType> proc = this.getProcedures();
        if (!proc.contains(procedureType)) {
            proc.add(procedureType);
        }
    }

    public void addLocalVariable(FieldType var) {
        List<FieldType> vars = this.getLocalVariables();
        if (!vars.contains(var)) {
            vars.add(var);
        }
    }

    @Override
    public DatabaseType getEnclosedType() {
        return null;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isResolved() {
        if (this.types != null) {
            for (PLSQLType type : this.types) {
                if (type.isResolved()) continue;
                return false;
            }
        }
        if (this.cursors != null) {
            for (PLSQLCursorType cursor : this.cursors) {
                if (cursor.isResolved()) continue;
                return false;
            }
        }
        if (this.procedures != null) {
            for (ProcedureType procedure : this.procedures) {
                if (procedure.isResolved()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String shortName() {
        return this.toString();
    }

    public String toString() {
        return this.getTypeName();
    }
}

