/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class TransactionIsolationLevelSwitchListener
extends SessionEventAdapter {
    Map<Connection, String> connections = new HashMap<Connection, String>();

    public void postAcquireConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        Statement stmt1 = null;
        String isolationLevel = "";
        try {
            int i = conn.getTransactionIsolation();
            switch (i) {
                case 1: {
                    isolationLevel = "READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    isolationLevel = "READ COMMITTED";
                    break;
                }
                case 4: {
                    isolationLevel = "REPEATABLE READ";
                    break;
                }
                case 8: {
                    isolationLevel = "SERIALIZABLE";
                }
            }
            if (i > 0) {
                stmt1 = conn.createStatement();
                stmt1.execute("set transaction isolation level READ UNCOMMITTED");
                this.connections.put(conn, isolationLevel);
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("postAcquireConnection failed. ", sqlException);
        }
        finally {
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void preReleaseConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        Statement stmt = null;
        try {
            String isolationLevel = this.connections.remove(conn);
            if (isolationLevel != null) {
                stmt = conn.createStatement();
                stmt.execute("set transaction isolation level " + isolationLevel);
                stmt.close();
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("preReleaseConnection failed. ", sqlException);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

