/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.writing;

import java.sql.Date;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class MassInsertEmployeeUnitOfWorkTest
extends PerformanceTest {
    public MassInsertEmployeeUnitOfWorkTest() {
        this.setTestRunTime(100000L);
        this.setDescription("This tests the performance of unit of work mass inserts.");
    }

    @Override
    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int index = 0; index < 100; ++index) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("NewGuy");
            empInsert.setMale();
            empInsert.setLastName("Smith");
            empInsert.setSalary(1055);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            uow.registerObject((Object)empInsert);
        }
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        uow.executeNonSelectingCall((Call)new SQLCall("Delete from EMPLOYEE where F_NAME = 'NewGuy'"));
        uow.commit();
    }
}

