/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class ModTest
extends JPQLTestCase {
    private static ModTest getNewTestCaseNamed(String name, String ejbql, Class referenceClass) {
        ModTest test = new ModTest();
        test.setName(name);
        test.setEjbqlString(ejbql);
        test.setReferenceClass(referenceClass);
        return test;
    }

    public static ModTest getSimpleModTest() {
        String ejbql = "SELECT OBJECT(emp) FROM Employee emp WHERE MOD(emp.salary, 2) > 0";
        ModTest test = ModTest.getNewTestCaseNamed("Mod Test", ejbql, Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.mod((Expression)employee.get("salary"), (int)2).greaterThan(0);
        test.setOriginalObjectExpression(whereClause);
        return test;
    }

    public static ModTest getComplexModTest() {
        ModTest test = ModTest.getSimpleModTest();
        test.setName("Complex " + test.getName());
        test.setEjbqlString(test.getEjbqlString() + " AND emp.firstName <> \"XCV\"");
        return test;
    }

    @Override
    public void setup() {
        if (this.getSession().getLogin().getPlatform().isSQLServer() || this.getSession().getLogin().getPlatform().isSybase()) {
            throw new TestWarningException("This test is not supported on SQL Server and Sybase. Because 'MOD' is not a recognized function name on SQL Server and Sybase.");
        }
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(this.getReferenceClass());
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        super.setup();
    }
}

