/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.util.HashMap;
import java.util.Map;

public final class LogLevel
extends Enum<LogLevel> {
    public static final /* enum */ LogLevel ALL;
    public static final /* enum */ LogLevel FINEST;
    public static final /* enum */ LogLevel FINER;
    public static final /* enum */ LogLevel FINE;
    public static final /* enum */ LogLevel CONFIG;
    public static final /* enum */ LogLevel INFO;
    public static final /* enum */ LogLevel WARNING;
    public static final /* enum */ LogLevel SEVERE;
    public static final /* enum */ LogLevel OFF;
    public static final int length;
    private static final Map<String, LogLevel> stringValuesMap;
    private static final LogLevel[] idValues;
    private final byte id;
    private final String name;
    private static final /* synthetic */ LogLevel[] ENUM$VALUES;

    static {
        LogLevel logLevel;
        ALL = new LogLevel(0, "ALL");
        FINEST = new LogLevel(1, "FINEST");
        FINER = new LogLevel(2, "FINER");
        FINE = new LogLevel(3, "FINE");
        CONFIG = new LogLevel(4, "CONFIG");
        INFO = new LogLevel(5, "INFO");
        WARNING = new LogLevel(6, "WARNING");
        SEVERE = new LogLevel(7, "SEVERE");
        OFF = new LogLevel(8, "OFF");
        ENUM$VALUES = new LogLevel[]{ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF};
        length = LogLevel.values().length;
        stringValuesMap = new HashMap<String, LogLevel>(2 * length);
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            logLevel = logLevelArray[n2];
            stringValuesMap.put(logLevel.name.toUpperCase(), logLevel);
            ++n2;
        }
        idValues = new LogLevel[length];
        logLevelArray = LogLevel.values();
        n = logLevelArray.length;
        n2 = 0;
        while (n2 < n) {
            LogLevel.idValues[logLevel.id] = logLevel = logLevelArray[n2];
            ++n2;
        }
    }

    public static final LogLevel toValue(String name) {
        return name != null ? stringValuesMap.get(name.toUpperCase()) : null;
    }

    public static final LogLevel toValue(int id) {
        if (id < 0 || id >= length) {
            throw new IllegalArgumentException("Log level ID " + id + "is out of range <0, " + Integer.toString(length) + ">.");
        }
        return idValues[id];
    }

    public static final LogLevel toValue(int id, LogLevel fallBack) {
        if (id >= 0 && id < length) {
            return idValues[id];
        }
        return fallBack;
    }

    private LogLevel(byte id, String name) {
        this.id = id;
        this.name = name;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldLog(LogLevel level) {
        return this.id <= level.id;
    }

    public boolean shouldLog(byte id) {
        return this.id <= id;
    }

    public static LogLevel[] values() {
        LogLevel[] logLevelArray = ENUM$VALUES;
        int n = logLevelArray.length;
        LogLevel[] logLevelArray2 = new LogLevel[n];
        System.arraycopy(ENUM$VALUES, 0, logLevelArray2, 0, n);
        return logLevelArray2;
    }

    public static LogLevel valueOf(String string) {
        return Enum.valueOf(LogLevel.class, string);
    }
}

