/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.sql.Time;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.WorkbenchIntegrationSystemHelper;

public class ReturningPolicyWorkbenchIntegrationTest
extends AutoVerifyTestCase {
    static int PROJECT_XML = 1;
    static int PROJECT_CLASS_GENERATED = 2;
    static String fileName = "ReturningPolicyMWIntegrationEmployeeProject";
    int mode;
    Project originalProject;
    Project project;

    public static ReturningPolicyWorkbenchIntegrationTest projectXML() {
        return new ReturningPolicyWorkbenchIntegrationTest(PROJECT_XML);
    }

    public static ReturningPolicyWorkbenchIntegrationTest projectClassGenerated() {
        return new ReturningPolicyWorkbenchIntegrationTest(PROJECT_CLASS_GENERATED);
    }

    ReturningPolicyWorkbenchIntegrationTest(int mode) {
        this.mode = mode;
        String strMode = null;
        if (mode == PROJECT_XML) {
            strMode = " XMLProj";
        } else if (mode == PROJECT_CLASS_GENERATED) {
            strMode = " ProjClassGen";
        }
        this.setName(this.getName() + strMode);
    }

    protected void setup() throws Exception {
        this.originalProject = new EmployeeProjectAmended();
        if (this.mode == PROJECT_XML) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectXML(this.originalProject, fileName);
        } else if (this.mode == PROJECT_CLASS_GENERATED) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectClass(this.originalProject, fileName);
        } else {
            throw new TestWarningException("Invalid mode");
        }
    }

    protected void verify() {
        ReturningPolicy returningPolicy;
        ReturningPolicy originalReturningPolicy = this.originalProject.getDescriptor(Employee.class).getReturningPolicy();
        if (!originalReturningPolicy.hasEqualFieldInfos(returningPolicy = this.project.getDescriptor(Employee.class).getReturningPolicy())) {
            throw new TestErrorException("Returning policy changed");
        }
    }

    static class EmployeeProjectAmended
    extends EmployeeProject {
        EmployeeProjectAmended() {
        }

        @Override
        public ClassDescriptor buildEmployeeDescriptor() {
            ClassDescriptor desc = super.buildEmployeeDescriptor();
            ReturningPolicy policy = new ReturningPolicy();
            desc.setReturningPolicy(policy);
            desc.setSequenceNumberFieldName(null);
            desc.setSequenceNumberName(null);
            policy.addFieldForInsertReturnOnly("EMPLOYEE.EMP_ID");
            policy.addFieldForInsert("EMPLOYEE.START_DATE");
            policy.addFieldForInsert("EMPLOYEE.END_DATE");
            policy.addFieldForUpdate("EMPLOYEE.END_DATE");
            policy.addFieldForInsert("EMPLOYEE.START_TIME", Time.class);
            policy.addFieldForUpdate("EMPLOYEE.END_TIME", Time.class);
            policy.addFieldForInsert("SALARY.SALARY");
            policy.addFieldForUpdate("SALARY.SALARY");
            return desc;
        }
    }
}

