/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;
import org.eclipse.persistence.testing.tests.proxyindirection.LargeProjectImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Project;

public class UnitOfWorkUpdateWithNewObjectTest
extends AutoVerifyTestCase {
    public UnitOfWorkUpdateWithNewObjectTest() {
        this.setDescription("Tests replacing a Proxy Indirection object with a new object in a UnitOfWork.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Rick%"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee eClone = (Employee)uow.registerObject((Object)emp);
        LargeProjectImpl project = new LargeProjectImpl();
        project.setName("TopLink for Java 4.0");
        project.setDescription("Object-Relational mapping framework");
        project.setBudget(100000.0);
        project.setInvestor("Oracle Corp.");
        eClone.setProject(project);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Rick"));
        Project project = emp.getProject();
        if (!project.getName().equals("TopLink for Java 4.0")) {
            throw new TestErrorException("Updating with a new object did not work properly.");
        }
    }
}

