/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureArgument;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.Combo;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class ValueInArgumentPane
extends AbstractSubjectPanel {
    public ValueInArgumentPane(PropertyValueModel argumentHolder, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)argumentHolder, workbenchContextHolder);
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JButton editButton = new JButton(this.buildEditAction());
        editButton.setText(this.resourceRepository().getString("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_EDIT_BUTTON"));
        JTextField argumentValueField = new JTextField(this.buildArgumentValueDocument(), null, 20);
        JComponent argumentValueWidgets = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_COLUMN", argumentValueField, editButton);
        argumentValueField.setEditable(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)argumentValueWidgets, constraints);
        Spacer endSpacer = new Spacer(-1);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)endSpacer, constraints);
    }

    private Action buildEditAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArgumentValueDialog dialog = new ArgumentValueDialog(ValueInArgumentPane.this.getWorkbenchContext(), ValueInArgumentPane.this.getSubjectHolder());
                dialog.show();
                if (dialog.wasConfirmed()) {
                    ((MWAbstractProcedureArgument)ValueInArgumentPane.this.subject()).setArgumentValue(dialog.getArgumentValue());
                }
            }
        };
    }

    private Document buildArgumentValueDocument() {
        return new DocumentAdapter(this.buildArgumentValueHolder());
    }

    private PropertyValueModel buildArgumentValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentValue"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWAbstractProcedureArgument)ValueInArgumentPane.this.subject()).getArgumentValue();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWAbstractProcedureArgument)ValueInArgumentPane.this.subject()).setArgumentValue((String)value);
            }
        };
    }

    private class ArgumentValueDialog
    extends AbstractDialog {
        private JTextField argumentValueTextField;
        private Combo typeChooser;
        private ValueModel argumentHolder;

        private ArgumentValueDialog(WorkbenchContext context, ValueModel argumentHolder) {
            super(context);
            this.argumentHolder = argumentHolder;
        }

        @Override
        protected AbstractSubjectPanel buildMainPanel() {
            return new DialogPane(ValueInArgumentPane.this.getSubjectHolder(), this.getApplicationContext());
        }

        protected MWAbstractProcedureArgument argument() {
            return (MWAbstractProcedureArgument)this.argumentHolder.getValue();
        }

        protected String getInvalidInputMessageKey(Class javaClass, List<String> arguments) {
            String javaClassName = javaClass.getName();
            if (javaClassName.equals("java.lang.Boolean")) {
                return "BE_EITHER_TRUE_OR_FALSE";
            }
            if (javaClassName.equals("java.lang.Byte")) {
                return "BE_BETWEEN_0_AND_127";
            }
            if (javaClassName.equals("java.lang.Character")) {
                return "BE_SINGLE_CHARACTER";
            }
            if (javaClassName.equals("java.lang.Double")) {
                CollectionTools.addAll(arguments, (Object[])new String[]{NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
                return "BE_BETWEEN_DOUBLE";
            }
            if (javaClassName.equals("java.lang.Float")) {
                CollectionTools.addAll(arguments, (Object[])new String[]{NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
                return "BE_BETWEEN_FLOAT";
            }
            if (javaClassName.equals("java.lang.Integer")) {
                CollectionTools.addAll(arguments, (Object[])new String[]{NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
                return "BE_BETWEEN_INT";
            }
            if (javaClassName.equals("java.lang.Long")) {
                CollectionTools.addAll(arguments, (Object[])new String[]{NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
                return "BE_BETWEEN_LONG";
            }
            if (javaClassName.equals("java.lang.Short")) {
                CollectionTools.addAll(arguments, (Object[])new String[]{NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
                return "BE_BETWEEN_SHORT";
            }
            if (javaClassName.equals("java.lang.String")) {
                return "BE_A_STRING";
            }
            if (javaClassName.equals("java.math.BigDecimal")) {
                return "CONTAINS_ONLY_DIGITS";
            }
            if (javaClassName.equals("java.math.BigInteger")) {
                return "CONTAINS_ONLY_DIGITS_AND";
            }
            if (javaClassName.equals("java.sql.Date")) {
                return "BE_IN_FORMAT1";
            }
            if (javaClassName.equals("java.sql.Time")) {
                return "BE_IN_FORMAT2";
            }
            if (javaClassName.equals("java.sql.Timestamp")) {
                return "BE_IN_FORMAT3";
            }
            if (javaClassName.equals("java.util.Date")) {
                return "BE_IN_FORMAT4";
            }
            if (javaClassName.equals("java.util.Calendar")) {
                return "BE_IN_FORMAT5";
            }
            if (javaClass == byte[].class || javaClass == Byte[].class) {
                return "BE_IN_FORMAT_BYTE_ARRAY";
            }
            if (javaClass == char[].class || javaClass == Character[].class) {
                return "BE_A_STRING";
            }
            return "ILLEGAL_FORMAT";
        }

        @Override
        protected String helpTopicId() {
            return "storedprocedure.arguments.value.editDialog";
        }

        @Override
        public boolean preConfirm() {
            try {
                this.argument().buildValueFromString((String)this.typeChooser.getSelectedItem(), this.argumentValueTextField.getText());
            }
            catch (ConversionException ce) {
                this.showInvalidConversionDialog(ce);
                return false;
            }
            return true;
        }

        public String getArgumentValue() {
            return this.argumentValueTextField.getText();
        }

        private void showInvalidConversionDialog(ConversionException ce) {
            Vector<String> arguments = new Vector<String>();
            arguments.add(ce.getClassToConvertTo().getName());
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString(this.getInvalidInputMessageKey(ce.getClassToConvertTo(), arguments), arguments.toArray()), this.resourceRepository().getString("ILLEGAL_FORMAT"), 2);
        }

        private void updateOKButton() {
            boolean enableOKButton = this.argumentValueTextField.getText() != null && !this.argumentValueTextField.getText().equals("");
            this.getOKAction().setEnabled(enableOKButton);
        }

        private class DialogPane
        extends AbstractSubjectPanel {
            DialogPane(ValueModel subjectHolder, ApplicationContext context) {
                super(subjectHolder, context);
            }

            private ComboBoxModel buildValueTypeComboboxModel() {
                return new ComboBoxModelAdapter(this.buildValueTypeChooserValueModel(), this.buildValueTypeChooserPropertyAdapter());
            }

            private ListValueModel buildValueTypeChooserValueModel() {
                return new ListAspectAdapter(ArgumentValueDialog.this.argumentHolder){

                    @Override
                    protected ListIterator getValueFromSubject() {
                        return MWAbstractProcedureArgument.buildBasicTypesList().listIterator();
                    }
                };
            }

            private PropertyValueModel buildValueTypeChooserPropertyAdapter() {
                return new SimplePropertyValueModel();
            }

            @Override
            protected void initializeLayout() {
                this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                ArgumentValueDialog.this.setTitle(this.resourceRepository().getString("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_EDIT_DIALOG_TITLE"));
                GridBagConstraints constraints = new GridBagConstraints();
                ArgumentValueDialog.this.typeChooser = new Combo(this.buildValueTypeComboboxModel());
                JComponent argumentValueTypeSelector = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_CLASS_COLUMN", ArgumentValueDialog.this.typeChooser);
                ArgumentValueDialog.this.typeChooser.setSelectedIndex(8);
                ArgumentValueDialog.this.typeChooser.setEditable(false);
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.fill = 2;
                constraints.anchor = 21;
                constraints.insets = new Insets(5, 0, 0, 0);
                this.add((Component)argumentValueTypeSelector, constraints);
                ArgumentValueDialog.this.argumentValueTextField = new JTextField(20);
                JComponent argumentValueWidgets = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_COLUMN", ArgumentValueDialog.this.argumentValueTextField);
                ArgumentValueDialog.this.argumentValueTextField.getDocument().addDocumentListener(new CVDocumentListener());
                ArgumentValueDialog.this.argumentValueTextField.setColumns(20);
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.fill = 2;
                constraints.anchor = 21;
                constraints.insets = new Insets(5, 0, 0, 0);
                this.add((Component)argumentValueWidgets, constraints);
                Spacer spacer = new Spacer(-1);
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 3;
                constraints.anchor = 10;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)spacer, constraints);
                ArgumentValueDialog.this.updateOKButton();
            }
        }

        private class CVDocumentListener
        implements DocumentListener {
            private CVDocumentListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                ArgumentValueDialog.this.updateOKButton();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                ArgumentValueDialog.this.updateOKButton();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                ArgumentValueDialog.this.updateOKButton();
            }
        }
    }
}

