/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackageNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackagePoolNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.EnumerationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class MultipleClassChooserDialog
extends AbstractDialog {
    private JTree availableTree;
    private JTree selectedTree;
    private ClassDescriptionRepository repository;
    private ClassDescriptionAdapter adapter;
    private ClassDescriptionPackagePoolNode availableRootNode;
    private ClassDescriptionPackagePoolNode selectedRootNode;
    private TreeModel availableTreeModel;
    TreeSelectionModel availableTreeSelectionModel;
    private TreeModel selectedTreeModel;
    TreeSelectionModel selectedTreeSelectionModel;
    private Action selectAction;
    private Action deselectAction;

    private MultipleClassChooserDialog(WorkbenchContext context) {
        super(context);
    }

    public MultipleClassChooserDialog(WorkbenchContext context, ClassDescriptionRepository repository) {
        this(context, repository, Collections.EMPTY_LIST, DefaultClassDescriptionAdapter.instance());
    }

    public MultipleClassChooserDialog(WorkbenchContext context, ClassDescriptionRepository repository, ClassDescriptionAdapter adapter) {
        this(context, repository, Collections.EMPTY_LIST, adapter);
    }

    public MultipleClassChooserDialog(WorkbenchContext context, ClassDescriptionRepository repository, Collection preSelectedMetaClasses, ClassDescriptionAdapter adapter) {
        this(context);
        this.repository = repository;
        this.adapter = adapter;
        this.initialize(preSelectedMetaClasses);
    }

    private MultipleClassChooserDialog(WorkbenchContext context, Dialog owner) {
        super(context, owner);
    }

    public MultipleClassChooserDialog(WorkbenchContext context, ClassDescriptionRepository repository, ClassDescriptionAdapter adapter, Dialog owner) {
        this(context, repository, Collections.EMPTY_LIST, adapter, owner);
    }

    public MultipleClassChooserDialog(WorkbenchContext context, ClassDescriptionRepository repository, Collection preSelectedMetaClasses, ClassDescriptionAdapter adapter, Dialog owner) {
        this(context, owner);
        this.repository = repository;
        this.adapter = adapter;
        this.initialize(preSelectedMetaClasses);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setSize(800, 400);
    }

    @Override
    protected void prepareToShow() {
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected String helpTopicId() {
        return "dialog.mutipleClassChooser";
    }

    private Action buildRefreshAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            @Override
            protected void initialize() {
                this.initializeText("refresh");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleClassChooserDialog.this.refresh();
            }
        };
    }

    private void initialize(Collection preSelectedMetaClasses) {
        this.availableRootNode = this.buildAvailableRootNode(preSelectedMetaClasses);
        this.availableTreeModel = new TreeModelAdapter(this.availableRootNode);
        this.availableTreeSelectionModel = this.buildAvailableTreeSelectionModel();
        this.selectedRootNode = this.buildSelectedRootNode(preSelectedMetaClasses);
        this.selectedTreeModel = new TreeModelAdapter(this.selectedRootNode);
        this.selectedTreeSelectionModel = this.buildSelectedTreeSelectionModel();
        this.selectAction = this.buildSelectAction();
        this.deselectAction = this.buildDeselectAction();
        this.setTitle(this.resourceRepository().getString("selectClasses.title"));
    }

    private ClassDescriptionPackagePoolNode buildAvailableRootNode(Collection preSelectedMetaClasses) {
        return new ClassDescriptionPackagePoolNode("available", this.repository.classDescriptions(), this.adapter, preSelectedMetaClasses, this.getWorkbenchContext());
    }

    private ClassDescriptionPackagePoolNode buildSelectedRootNode(Collection preSelectedMetaClasses) {
        return new ClassDescriptionPackagePoolNode("selected", preSelectedMetaClasses.iterator(), this.adapter, this.getWorkbenchContext());
    }

    private TreeSelectionModel buildTreeSelectionModel(TreeSelectionListener listener) {
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.addTreeSelectionListener(listener);
        return treeSelectionModel;
    }

    private TreeSelectionModel buildAvailableTreeSelectionModel() {
        return this.buildTreeSelectionModel(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MultipleClassChooserDialog.this.availableTreeSelectionChanged(e);
            }
        });
    }

    private TreeSelectionModel buildSelectedTreeSelectionModel() {
        return this.buildTreeSelectionModel(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MultipleClassChooserDialog.this.selectedTreeSelectionChanged(e);
            }
        });
    }

    private Action buildSelectAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getWorkbenchContext()){

            @Override
            public void actionPerformed(ActionEvent event) {
                MultipleClassChooserDialog.this.selectClassNodes();
            }

            @Override
            protected void initialize() {
                super.initializeIcon("shuttle.right");
            }
        };
        action.setEnabled(false);
        return action;
    }

    private Action buildDeselectAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getWorkbenchContext()){

            @Override
            public void actionPerformed(ActionEvent event) {
                MultipleClassChooserDialog.this.deselectClassNodes();
            }

            @Override
            protected void initialize() {
                super.initializeIcon("shuttle.left");
            }
        };
        action.setEnabled(false);
        return action;
    }

    private ClassDescriptionPackagePoolNode getAvailableRootNode() {
        return this.availableRootNode;
    }

    private ClassDescriptionPackagePoolNode getSelectedRootNode() {
        return this.selectedRootNode;
    }

    public Iterator selectedClassDescriptions() {
        return this.getSelectedRootNode().userClassDescriptions();
    }

    void availableTreeSelectionChanged(TreeSelectionEvent e) {
        this.selectAction.setEnabled(this.availableTreeSelectionModel.getSelectionCount() != 0);
    }

    void selectedTreeSelectionChanged(TreeSelectionEvent e) {
        this.deselectAction.setEnabled(this.selectedTreeSelectionModel.getSelectionCount() != 0);
    }

    private Collection expandedPaths(JTree tree, Object root) {
        Enumeration<TreePath> stream = tree.getExpandedDescendants(new TreePath(root));
        if (stream == null) {
            return Collections.EMPTY_LIST;
        }
        return CollectionTools.list((Iterator)new EnumerationIterator(stream));
    }

    private void moveClassNodes(ClassDescriptionPackagePoolNode source, ClassDescriptionPackagePoolNode target, TreeSelectionModel sourceSelectionModel, TreeSelectionModel targetSelectionModel, JTree targetTree) {
        boolean expandTargetRootNode = target.isLeaf();
        Collection expandedPaths = this.expandedPaths(targetTree, target);
        TreePath[] selectedPaths = sourceSelectionModel.getSelectionPaths();
        HashSet selectedClassNodes = new HashSet();
        int i = selectedPaths.length;
        while (i-- > 0) {
            ClassDescriptionNodeContainer selectedNode = (ClassDescriptionNodeContainer)selectedPaths[i].getLastPathComponent();
            selectedNode.addClassDescriptionNodesTo(selectedClassNodes);
        }
        HashSet<ClassDescriptionPackageNode> selectedPackageNodes = new HashSet<ClassDescriptionPackageNode>();
        for (ClassDescriptionNode classNode : selectedClassNodes) {
            source.removeClassNode(classNode);
            target.addClassNode(classNode);
            selectedPackageNodes.add(classNode.getPackageNode());
        }
        for (ClassDescriptionPackageNode packageNode : selectedPackageNodes) {
            targetTree.expandPath(new TreePath(packageNode.path()));
        }
        Iterator stream = expandedPaths.iterator();
        while (stream.hasNext()) {
            targetTree.expandPath((TreePath)stream.next());
        }
        if (expandTargetRootNode) {
            targetTree.expandPath(new TreePath(target));
        }
        TreePath[] newSelectedPaths = new TreePath[selectedClassNodes.size()];
        Iterator stream2 = selectedClassNodes.iterator();
        for (int i2 = 0; i2 < newSelectedPaths.length; ++i2) {
            ClassDescriptionNode classNode = (ClassDescriptionNode)stream2.next();
            newSelectedPaths[i2] = new TreePath(classNode.path());
        }
        targetSelectionModel.setSelectionPaths(newSelectedPaths);
    }

    void selectClassNodes() {
        this.moveClassNodes(this.getAvailableRootNode(), this.getSelectedRootNode(), this.availableTreeSelectionModel, this.selectedTreeSelectionModel, this.selectedTree);
    }

    void deselectClassNodes() {
        this.moveClassNodes(this.getSelectedRootNode(), this.getAvailableRootNode(), this.selectedTreeSelectionModel, this.availableTreeSelectionModel, this.availableTree);
    }

    void refresh() {
        this.repository.refreshClassDescriptions();
        this.availableRootNode = this.buildAvailableRootNode(Collections.EMPTY_LIST);
        this.availableTreeModel = new TreeModelAdapter(this.availableRootNode);
        this.availableTree.setModel(this.availableTreeModel);
        this.selectedRootNode = this.buildSelectedRootNode(Collections.EMPTY_LIST);
        this.selectedTreeModel = new TreeModelAdapter(this.selectedRootNode);
        this.selectedTree.setModel(this.selectedTreeModel);
    }

    private JTree buildTree(TreeModel treeModel, TreeSelectionModel treeSelectionModel) {
        JTree tree = SwingComponentFactory.buildTree(treeModel);
        tree.setSelectionModel(treeSelectionModel);
        tree.setCellRenderer(new DisplayableTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setRowHeight(20);
        tree.setDoubleBuffered(true);
        return tree;
    }

    private JTree buildAvailableTree() {
        JTree tree = this.buildTree(this.availableTreeModel, this.availableTreeSelectionModel);
        tree.addMouseListener(this.buildDoubleClickSelect());
        return tree;
    }

    private MouseListener buildDoubleClickSelect() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MultipleClassChooserDialog.this.availableTreeSelectionModel.getSelectionPaths() != null) {
                    MultipleClassChooserDialog.this.selectClassNodes();
                }
            }
        };
    }

    private JTree buildSelectedTree() {
        JTree tree = this.buildTree(this.selectedTreeModel, this.selectedTreeSelectionModel);
        tree.addMouseListener(this.buildDoubleClickDeselect());
        return tree;
    }

    private MouseListener buildDoubleClickDeselect() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MultipleClassChooserDialog.this.selectedTreeSelectionModel.getSelectionPaths() != null) {
                    MultipleClassChooserDialog.this.deselectClassNodes();
                }
            }
        };
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(this.resourceRepository().getString("availablePackages/classes"));
        availableLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("availablePackages/classes"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)availableLabel, constraints);
        this.availableTree = this.buildAvailableTree();
        this.helpManager().addTopicID(this.availableTree, this.helpTopicId() + ".available");
        JScrollPane availablePane = new JScrollPane(this.availableTree);
        availablePane.setPreferredSize(new Dimension(200, 100));
        availablePane.setMinimumSize(new Dimension(200, 100));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        mainPanel.add((Component)availablePane, constraints);
        availableLabel.setLabelFor(this.availableTree);
        JLabel selectedLabel = new JLabel(this.resourceRepository().getString("selectedClasses"));
        selectedLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("selectedClasses"));
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPanel.add((Component)selectedLabel, constraints);
        this.selectedTree = this.buildSelectedTree();
        this.helpManager().addTopicID(this.selectedTree, this.helpTopicId() + ".selected");
        JScrollPane selectedPane = new JScrollPane(this.selectedTree);
        selectedPane.setPreferredSize(new Dimension(200, 100));
        selectedPane.setMinimumSize(new Dimension(200, 100));
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 5);
        mainPanel.add((Component)selectedPane, constraints);
        selectedLabel.setLabelFor(this.selectedTree);
        JButton selectButton = new JButton(this.selectAction);
        selectButton.setToolTipText(this.resourceRepository().getString("addSelectedClassesToList"));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        mainPanel.add((Component)selectButton, constraints);
        JButton deselectButton = new JButton(this.deselectAction);
        deselectButton.setToolTipText(this.resourceRepository().getString("removeSelectedClassesFromList"));
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)deselectButton, constraints);
        return mainPanel;
    }

    @Override
    protected Iterator buildCustomActions() {
        return new SingleElementIterator((Object)this.buildRefreshAction());
    }

    public static void gc() {
        ClassChooserDialog.gc();
    }
}

