/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.AbstractCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.SystemCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class URLCLExternalClassRepository
extends AbstractCLExternalClassRepository {
    private final Classpath canonicalProjectClasspath;

    URLCLExternalClassRepository(File[] classpath) {
        Classpath tempClasspath = new Classpath(this.fileNames(classpath)).compressed();
        Classpath completeClasspath = Classpath.completeClasspath();
        this.canonicalProjectClasspath = this.removeDuplicates(completeClasspath, tempClasspath);
    }

    private String[] fileNames(File[] files) {
        int len = files.length;
        String[] fileNames = new String[len];
        for (int i = 0; i < len; ++i) {
            fileNames[i] = files[i].getAbsolutePath();
        }
        return fileNames;
    }

    private Classpath removeDuplicates(Classpath classpath1, Classpath classpath2) {
        Set classpathEntries1 = CollectionTools.set(classpath1.getEntries());
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Classpath.Entry entry2 : classpath2.getEntries()) {
            if (classpathEntries1.contains(entry2)) continue;
            fileNames.add(entry2.fileName());
        }
        return new Classpath(fileNames);
    }

    @Override
    public ExternalClassDescription getClassDescription(String className) {
        ExternalClassDescription ecd = SystemCLExternalClassRepository.instance().getClassDescription(className);
        if (ecd != null) {
            return ecd;
        }
        return super.getClassDescription(className);
    }

    @Override
    Map buildClassDescriptions() {
        HashMap classDescriptions = new HashMap(20000);
        SystemCLExternalClassRepository.instance().addClassDescriptionsTo(classDescriptions);
        this.addClassDescriptionsFromClasspathTo(this.canonicalProjectClasspath, classDescriptions);
        return classDescriptions;
    }

    @Override
    ClassLoader buildClassLoader() {
        return new URLClassLoader(this.canonicalProjectClasspath.urls());
    }
}

