/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.MetadataCatalog;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.Property;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.Reference;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.Resource;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.ResourceSchema;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ItemLinksBuilder;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/{version : v\\d\\.\\d|latest}/{context}/metadata-catalog/")
public class MetadataResource
extends AbstractResource {
    private static final String CLASS_NAME = MetadataResource.class.getName();
    private static final Map<Class<?>, String> PRIMITIVE_TO_JSON = new HashMap();

    static {
        PRIMITIVE_TO_JSON.put(Boolean.TYPE, "boolean");
        PRIMITIVE_TO_JSON.put(Byte.TYPE, "number");
        PRIMITIVE_TO_JSON.put(Character.TYPE, "string");
        PRIMITIVE_TO_JSON.put(Double.TYPE, "number");
        PRIMITIVE_TO_JSON.put(Float.TYPE, "number");
        PRIMITIVE_TO_JSON.put(Integer.TYPE, "integer");
        PRIMITIVE_TO_JSON.put(Long.TYPE, "integer");
        PRIMITIVE_TO_JSON.put(Short.TYPE, "number");
        PRIMITIVE_TO_JSON.put(Short.TYPE, "number");
    }

    @GET
    public Response getMetadataCatalog(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        this.setRequestUniqueId();
        return this.buildMetadataCatalogResponse(version, persistenceUnit, httpHeaders, uriInfo);
    }

    @GET
    @Produces(value={"application/json", "application/schema+json"})
    @Consumes(value={"application/json", "application/schema+json"})
    @Path(value="entity/{entityName}")
    public Response getEntityResource(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="entityName") String entityName, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        this.setRequestUniqueId();
        MediaType mediaType = StreamingOutputMarshaller.mediaType(httpHeaders.getAcceptableMediaTypes());
        if (mediaType.equals((Object)AbstractResource.APPLICATION_SCHEMA_JSON_TYPE)) {
            return this.buildEntitySchemaResponse(version, persistenceUnit, entityName, uriInfo);
        }
        return this.buildEntityMetadataResponse(version, persistenceUnit, entityName, httpHeaders, uriInfo);
    }

    @GET
    @Produces(value={"application/json", "application/schema+json"})
    @Consumes(value={"application/json", "application/schema+json"})
    @Path(value="query/{queryName}")
    public Response getQueryResource(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="queryName") String queryName, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        this.setRequestUniqueId();
        MediaType mediaType = StreamingOutputMarshaller.mediaType(httpHeaders.getAcceptableMediaTypes());
        if (mediaType.equals((Object)AbstractResource.APPLICATION_SCHEMA_JSON_TYPE)) {
            return this.buildQuerySchemaResponse(version, persistenceUnit, queryName, uriInfo);
        }
        return this.buildQueryMetadataResponse(version, persistenceUnit, queryName, httpHeaders, uriInfo);
    }

    private Response buildMetadataCatalogResponse(String version, String persistenceUnit, HttpHeaders httpHeaders, UriInfo uriInfo) {
        String result;
        JPARSLogger.entering(CLASS_NAME, "buildMetadataCatalogResponse", new Object[]{"GET", version, persistenceUnit, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            MetadataCatalog catalog = this.buildMetadataCatalog(context);
            String mediaType = StreamingOutputMarshaller.mediaType(httpHeaders.getAcceptableMediaTypes()).toString();
            result = this.marshallMetadata(catalog, mediaType);
        }
        catch (JAXBException e) {
            throw JPARSException.exceptionOccurred((Exception)((Object)e));
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, httpHeaders.getAcceptableMediaTypes())).build();
    }

    private Response buildEntityMetadataResponse(String version, String persistenceUnit, String entityName, HttpHeaders httpHeaders, UriInfo uriInfo) {
        String result;
        JPARSLogger.entering(CLASS_NAME, "buildEntityMetadataResponse", new Object[]{"GET", version, persistenceUnit, entityName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            ClassDescriptor descriptor = context.getServerSession().getDescriptorForAlias(entityName);
            if (descriptor == null) {
                JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_entity_type", new Object[]{entityName, persistenceUnit});
                throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(entityName, persistenceUnit);
            }
            String mediaType = StreamingOutputMarshaller.mediaType(httpHeaders.getAcceptableMediaTypes()).toString();
            Resource resource = this.buildEntityMetadata(context, descriptor);
            result = this.marshallMetadata(resource, mediaType);
        }
        catch (JAXBException e) {
            throw JPARSException.exceptionOccurred((Exception)((Object)e));
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, httpHeaders.getAcceptableMediaTypes())).build();
    }

    private Response buildQueryMetadataResponse(String version, String persistenceUnit, String queryName, HttpHeaders httpHeaders, UriInfo uriInfo) {
        String result;
        JPARSLogger.entering(CLASS_NAME, "buildQueryMetadataResponse", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            DatabaseQuery query = context.getServerSession().getQuery(queryName);
            if (query == null) {
                JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_query", new Object[]{queryName, persistenceUnit});
                throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
            }
            String mediaType = StreamingOutputMarshaller.mediaType(httpHeaders.getAcceptableMediaTypes()).toString();
            Resource resource = this.buildQueryMetadata(context, query);
            result = this.marshallMetadata(resource, mediaType);
        }
        catch (JAXBException e) {
            throw JPARSException.exceptionOccurred((Exception)((Object)e));
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, httpHeaders.getAcceptableMediaTypes())).build();
    }

    private Response buildEntitySchemaResponse(String version, String persistenceUnit, String entityName, UriInfo uriInfo) {
        String result;
        JPARSLogger.entering(CLASS_NAME, "buildEntitySchemaResponse", new Object[]{"GET", version, persistenceUnit, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            ClassDescriptor descriptor = context.getServerSession().getDescriptorForAlias(entityName);
            if (descriptor == null) {
                JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_entity_type", new Object[]{entityName, persistenceUnit});
                throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(entityName, persistenceUnit);
            }
            ResourceSchema schema = new ResourceSchema();
            schema.setTitle(descriptor.getAlias());
            schema.setSchema(String.valueOf(HrefHelper.buildEntityMetadataHref(context, descriptor.getAlias())) + "#");
            schema.addAllOf(new Reference(HrefHelper.buildBaseRestSchemaRef("#/singularResource")));
            for (DatabaseMapping databaseMapping : descriptor.getMappings()) {
                schema.addProperty(databaseMapping.getAttributeName(), this.buildProperty(context, databaseMapping));
            }
            String instancesHref = HrefHelper.buildEntityDescribesHref(context, descriptor.getAlias());
            schema.setLinks(new ItemLinksBuilder().addDescribedBy(HrefHelper.buildEntityMetadataHref(context, descriptor.getAlias())).addFind(String.valueOf(instancesHref) + "/{primaryKey}").addCreate(instancesHref).addUpdate(instancesHref).addDelete(String.valueOf(instancesHref) + "/{primaryKey}").getList());
            result = this.marshallMetadata(schema, "application/json");
        }
        catch (JAXBException e) {
            throw JPARSException.exceptionOccurred((Exception)((Object)e));
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, AbstractResource.APPLICATION_SCHEMA_JSON_TYPE)).build();
    }

    private Response buildQuerySchemaResponse(String version, String persistenceUnit, String queryName, UriInfo uriInfo) {
        String result;
        JPARSLogger.entering(CLASS_NAME, "buildQuerySchemaResponse", new Object[]{"GET", version, persistenceUnit, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            DatabaseQuery query = context.getServerSession().getQuery(queryName);
            if (query == null) {
                JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_query", new Object[]{queryName, persistenceUnit});
                throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
            }
            ResourceSchema querySchema = this.buildQuerySchema(context, query);
            result = this.marshallMetadata(querySchema, "application/json");
        }
        catch (JAXBException e) {
            throw JPARSException.exceptionOccurred((Exception)((Object)e));
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, AbstractResource.APPLICATION_SCHEMA_JSON_TYPE)).build();
    }

    private MetadataCatalog buildMetadataCatalog(PersistenceContext context) {
        MetadataCatalog result = new MetadataCatalog();
        Map<Class, ClassDescriptor> descriptors = context.getServerSession().getDescriptors();
        for (Class clazz : descriptors.keySet()) {
            ClassDescriptor descriptor = descriptors.get(clazz);
            if (descriptor.isAggregateDescriptor()) continue;
            result.addResource(this.buildEntityMetadata(context, descriptor));
        }
        Map<String, List<DatabaseQuery>> allQueries = context.getServerSession().getQueries();
        for (List list : allQueries.values()) {
            if (list == null) continue;
            for (DatabaseQuery query : list) {
                if (query.getReferenceClassName() == null) continue;
                result.addResource(this.buildQueryMetadata(context, query));
            }
        }
        String string = HrefHelper.buildMetadataCatalogHref(context);
        List<LinkV2> links = new ItemLinksBuilder().addCanonical(string).getList();
        result.setLinks(links);
        return result;
    }

    private Resource buildEntityMetadata(PersistenceContext context, ClassDescriptor descriptor) {
        Resource resource = new Resource();
        resource.setName(descriptor.getAlias());
        String metadataHref = HrefHelper.buildEntityMetadataHref(context, descriptor.getAlias());
        List<LinkV2> links = new ItemLinksBuilder().addAlternate(metadataHref).addCanonical(metadataHref, "application/json").addDescribes(HrefHelper.buildEntityDescribesHref(context, descriptor.getAlias())).getList();
        resource.setLinks(links);
        return resource;
    }

    private Resource buildQueryMetadata(PersistenceContext context, DatabaseQuery query) {
        Resource resource = new Resource();
        resource.setName(query.getName());
        String metadataHref = HrefHelper.buildQueryMetadataHref(context, query.getName());
        List<LinkV2> links = new ItemLinksBuilder().addAlternate(metadataHref).addCanonical(metadataHref, "application/json").addDescribes(HrefHelper.buildQueryDescribesHref(context, query.getName())).getList();
        resource.setLinks(links);
        return resource;
    }

    private ResourceSchema buildQuerySchema(PersistenceContext context, DatabaseQuery query) {
        ResourceSchema schema = new ResourceSchema();
        schema.setTitle(query.getName());
        schema.setSchema(String.valueOf(HrefHelper.buildQueryMetadataHref(context, query.getName())) + "#");
        schema.addAllOf(new Reference(HrefHelper.buildBaseRestSchemaRef("#/collectionBaseResource")));
        String method = query.isReadQuery() ? "GET" : "POST";
        schema.setLinks(new ItemLinksBuilder().addExecute(HrefHelper.buildQueryHref(context, query.getName(), this.getQueryParamString(query)), method).getList());
        if (query.isReportQuery()) {
            ResourceSchema returnType = new ResourceSchema();
            query.checkPrepare((AbstractSession)((Object)context.getServerSession()), new DatabaseRecord());
            for (ReportItem item : ((ReportQuery)query).getItems()) {
                Property property = item.getMapping() != null ? (item.getAttributeExpression() != null && item.getAttributeExpression().isMapEntryExpression() ? (((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry() ? this.buildProperty(context, Map.Entry.class) : this.buildProperty(context, (Class)item.getMapping().getContainerPolicy().getKeyType())) : this.buildProperty(context, item.getMapping().getAttributeClassification())) : (item.getResultType() != null ? this.buildProperty(context, item.getResultType()) : (item.getDescriptor() != null ? this.buildProperty(context, item.getDescriptor().getJavaClass()) : (item.getAttributeExpression() != null && item.getAttributeExpression().isConstantExpression() ? this.buildProperty(context, ((ConstantExpression)item.getAttributeExpression()).getValue().getClass()) : this.buildProperty(context, Object.class))));
                returnType.addProperty(item.getName(), property);
            }
            schema.addDefinition("result", returnType);
            Property items = new Property();
            items.setType("array");
            items.setItems(new Property("#/definitions/result"));
            schema.addProperty("items", items);
        } else if (query.getReferenceClassName() != null) {
            Property items = new Property();
            items.setType("array");
            items.setItems(new Property(String.valueOf(HrefHelper.buildEntityMetadataHref(context, query.getReferenceClass().getSimpleName())) + "#"));
            schema.addProperty("items", items);
        }
        return schema;
    }

    private String getQueryParamString(DatabaseQuery query) {
        StringBuilder queryParams = new StringBuilder();
        for (String arg : query.getArguments()) {
            queryParams.append(";");
            queryParams.append(arg).append("={").append(arg).append("}");
        }
        return queryParams.toString();
    }

    private Property buildProperty(PersistenceContext context, DatabaseMapping mapping) {
        if (mapping.isCollectionMapping()) {
            Property property = new Property();
            property.setType("array");
            property.setItems(this.buildProperty(context, this.getCollectionGenericClass(mapping)));
            return property;
        }
        if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)mapping;
            String href = HrefHelper.buildEntityMetadataHref(context, String.valueOf(foreignReferenceMapping.getReferenceClass().getSimpleName()) + "#");
            return new Property(href);
        }
        return this.buildProperty(context, mapping.getAttributeClassification());
    }

    private Property buildProperty(PersistenceContext context, Class clazz) {
        Property property = new Property();
        if (context.getServerSession().getDescriptorForAlias(clazz.getSimpleName()) != null) {
            property.setRef(String.valueOf(HrefHelper.buildEntityMetadataHref(context, clazz.getSimpleName())) + "#");
        } else if (Number.class.isAssignableFrom(clazz)) {
            property.setType("number");
        } else if (Boolean.class.equals((Object)clazz)) {
            property.setType("boolean");
        } else if (String.class.equals((Object)clazz)) {
            property.setType("string");
        } else if (Collection.class.isAssignableFrom(clazz)) {
            property.setType("array");
        } else if (clazz.isPrimitive()) {
            property.setType(PRIMITIVE_TO_JSON.get(clazz));
        } else {
            property.setType("object");
        }
        return property;
    }

    private Class getCollectionGenericClass(DatabaseMapping mapping) {
        Class collectionName = null;
        if (mapping.isEISMapping()) {
            EISCompositeCollectionMapping collectionMapping = (EISCompositeCollectionMapping)mapping;
            if (collectionMapping.getReferenceClass() != null) {
                collectionName = collectionMapping.getReferenceClass();
            }
            if (collectionName == null && collectionMapping.getAttributeClassification() != null) {
                collectionName = collectionMapping.getAttributeClassification();
            }
        } else {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            if (collectionMapping.getReferenceClass() != null) {
                collectionName = collectionMapping.getReferenceClass();
            }
            if (collectionName == null && collectionMapping.getAttributeClassification() != null) {
                collectionName = collectionMapping.getAttributeClassification();
            }
        }
        return collectionName;
    }
}

