/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddNewNamedPoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddReadPoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddSequencePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddWritePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.PoolNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.DatabaseSessionNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public class ServerSessionNode
extends DatabaseSessionNode {
    private ListValueModel childrenModel;

    public ServerSessionNode(ServerSessionAdapter session, TreeNodeValueModel parent, SCPlugin plugin, ApplicationContext context) {
        super(session, parent, plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext wrappedContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription desc = new RootMenuDescription();
        if (!this.serverSession().platformIsXml()) {
            MenuDescription newMenuDesc = new MenuDescription(this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getMnemonic("NEW_MENU"), EMPTY_ICON);
            MenuGroupDescription poolGroup = new MenuGroupDescription();
            poolGroup.add(this.getAddNamedPoolAction(wrappedContext));
            poolGroup.add(this.getAddSequencePoolAction(wrappedContext));
            poolGroup.add(this.getAddWritePoolAction(wrappedContext));
            poolGroup.add(this.getAddReadPoolAction(wrappedContext));
            newMenuDesc.add(poolGroup);
            MenuGroupDescription poolMainMenuGroup = new MenuGroupDescription();
            poolMainMenuGroup.add(newMenuDesc);
            desc.add(poolMainMenuGroup);
        }
        MenuGroupDescription deleteRenameGroup = new MenuGroupDescription();
        deleteRenameGroup.add(this.getRenameNodeAction(wrappedContext));
        deleteRenameGroup.add(this.getDeleteNodeAction(wrappedContext));
        desc.add(deleteRenameGroup);
        desc.add(this.buildHelpMenuGroup(wrappedContext));
        return desc;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext wrappedContext = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription desc = new ToolBarDescription();
        if (!this.serverSession().platformIsXml()) {
            ToolBarButtonGroupDescription poolGroup = new ToolBarButtonGroupDescription();
            poolGroup.add(this.getAddNamedPoolAction(wrappedContext));
            poolGroup.add(this.getAddSequencePoolAction(wrappedContext));
            poolGroup.add(this.getAddWritePoolAction(wrappedContext));
            poolGroup.add(this.getAddReadPoolAction(wrappedContext));
            desc.add(poolGroup);
        }
        return desc;
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildChildrenNodeWrapper(), "displayString");
    }

    protected ListValueModel buildChildrenNodeWrapper() {
        return new TransformationListValueModelAdapter(this.buildChildrenAspectAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return ServerSessionNode.this.buildChildNode((ConnectionPoolAdapter)item);
            }
        };
    }

    protected PoolNode buildChildNode(ConnectionPoolAdapter pool) {
        if (pool instanceof ReadConnectionPoolAdapter) {
            return this.buildReadConnectionPoolNode();
        }
        if (pool instanceof WriteConnectionPoolAdapter) {
            return this.buildWriteConnectionPoolNode();
        }
        return new PoolNode(pool, (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    protected CollectionValueModel buildChildrenAspectAdapter() {
        return new CollectionAspectAdapter(this, "pools"){

            @Override
            protected Iterator getValueFromSubject() {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                if (session.platformIsXml()) {
                    return NullIterator.instance();
                }
                Collection collection = CollectionTools.collection((Iterator)((ServerSessionAdapter)this.subject).pools());
                if (session.hasReadPool()) {
                    collection.add(session.getReadConnectionPool());
                }
                if (session.hasWritePool()) {
                    collection.add(session.getWriteConnectionPool());
                }
                if (session.hasSequencePool()) {
                    collection.add(session.getSequenceConnectionPool());
                }
                return collection.iterator();
            }

            @Override
            protected int sizeFromSubject() {
                int readPool = ((ServerSessionAdapter)this.subject).hasReadPool() ? 1 : 0;
                int writePool = ((ServerSessionAdapter)this.subject).hasWritePool() ? 1 : 0;
                int sequencePool = ((ServerSessionAdapter)this.subject).hasSequencePool() ? 1 : 0;
                return ((ServerSessionAdapter)this.subject).poolsSize() + readPool + writePool + sequencePool;
            }
        };
    }

    protected PoolNode buildReadConnectionPoolNode() {
        return new PoolNode(((ServerSessionAdapter)this.session()).getReadConnectionPool(), (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    protected PoolNode buildWriteConnectionPoolNode() {
        return new PoolNode(((ServerSessionAdapter)this.session()).getWriteConnectionPool(), (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    private FrameworkAction getAddNamedPoolAction(WorkbenchContext workbenchContext) {
        return new AddNewNamedPoolAction(workbenchContext);
    }

    private FrameworkAction getAddSequencePoolAction(WorkbenchContext workbenchContext) {
        return new AddSequencePoolAction(workbenchContext);
    }

    private FrameworkAction getAddWritePoolAction(WorkbenchContext workbenchContext) {
        return new AddWritePoolAction(workbenchContext);
    }

    private FrameworkAction getAddReadPoolAction(WorkbenchContext workbenchContext) {
        return new AddReadPoolAction(workbenchContext);
    }

    @Override
    protected List buildDisplayStringPropertyNamesList() {
        List displayStrings = super.buildDisplayStringPropertyNamesList();
        displayStrings.add("name");
        return displayStrings;
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    public String helpTopicID() {
        return "navigator.session.server";
    }

    private ServerSessionAdapter serverSession() {
        return (ServerSessionAdapter)this.session();
    }
}

