/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.testing.tests.queries.report.Bar;
import org.eclipse.persistence.testing.tests.queries.report.Brewer;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Beer
implements Cloneable,
Serializable {
    protected String key = null;
    protected String brand = null;
    protected Vector barCollection = null;
    protected Brewer brewer = null;

    public Beer() {
    }

    public Beer(String brand) {
        this.brand = brand;
    }

    public void addBar(Bar aBar) {
        this.getBarCollection().addElement(aBar);
        aBar.getBeerCollection().addElement(this);
    }

    public Vector getBarCollection() {
        if (this.barCollection == null) {
            this.barCollection = new Vector();
        }
        return this.barCollection;
    }

    public String getBrand() {
        return this.brand;
    }

    public Brewer getBrewer() {
        return this.brewer;
    }

    public String getKey() {
        return this.key;
    }

    public void removeBar(Bar aBar) {
        this.getBarCollection().remove(aBar);
        aBar.getBeerCollection().remove(this);
    }

    public boolean servedAt(Bar aBar) {
        return this.getBarCollection().contains(aBar);
    }

    public void setBarCollection(Vector newBarCollection) {
        this.barCollection = newBarCollection;
    }

    public void setBrand(String newBrand) {
        this.brand = newBrand;
    }

    public void setBrewer(Brewer brewer) {
        this.brewer = brewer;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public void go() {
        this.printSomething();
    }

    private void printSomething() {
        System.out.println("BEER");
    }

    public Object clone() {
        Beer beer = new Beer();
        beer.key = this.key;
        beer.brand = this.brand;
        return beer;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition table = new TableDefinition();
        table.setName("BEER");
        table.addField("KEY_BEER", String.class);
        table.addField("TXT_BRAND", String.class);
        table.addField("KEY_BREWER", String.class);
        return table;
    }
}

