/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class InstantiationPolicyTest
extends AutoVerifyTestCase {
    protected static boolean invokedFactoryStaticMethod = false;
    protected boolean invokedFactoryPhoneNumberMethod = false;

    public static void main(String[] args) throws Exception {
        InstantiationPolicyTest test = new InstantiationPolicyTest();
        test.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() throws Exception {
        DatabaseSession aSession = this.createTestSession();
        ClassDescriptor phoneDescriptor = aSession.getClassDescriptor(PhoneNumber.class);
        phoneDescriptor.useFactoryInstantiationPolicy(InstantiationPolicyTest.class, "createPhoneNumber");
        aSession.setSessionLog(this.getSession().getSessionLog());
        aSession.login();
        aSession.readObject(PhoneNumber.class);
        InstantiationPolicyTest factory = (InstantiationPolicyTest)((Object)phoneDescriptor.getInstantiationPolicy().getFactory());
        aSession.logout();
        if (!factory.invokedFactoryPhoneNumberMethod) {
            throw new TestErrorException("useFactoryInstantiationPolicy(Class, String) does not work.");
        }
        aSession = this.createTestSession();
        phoneDescriptor = aSession.getClassDescriptor(PhoneNumber.class);
        phoneDescriptor.useFactoryInstantiationPolicy(InstantiationPolicyTest.class, "createPhoneNumber", "createPhoneNumberFactory");
        aSession.login();
        aSession.readObject(PhoneNumber.class);
        factory = (InstantiationPolicyTest)((Object)phoneDescriptor.getInstantiationPolicy().getFactory());
        aSession.logout();
        if (!factory.invokedFactoryPhoneNumberMethod || !invokedFactoryStaticMethod) {
            throw new TestErrorException("useFactoryInstantiationPolicy(Class, String, String) does not work.");
        }
        aSession = this.createTestSession();
        phoneDescriptor = aSession.getClassDescriptor(PhoneNumber.class);
        phoneDescriptor.useFactoryInstantiationPolicy((Object)new InstantiationPolicyTest(), "createPhoneNumber");
        aSession.login();
        aSession.readObject(PhoneNumber.class);
        factory = (InstantiationPolicyTest)((Object)phoneDescriptor.getInstantiationPolicy().getFactory());
        aSession.logout();
        if (!factory.invokedFactoryPhoneNumberMethod || !invokedFactoryStaticMethod) {
            throw new TestErrorException("useFactoryInstantiationPolicy(Object, String) does not work.");
        }
        boolean hasException = false;
        try {
            aSession = this.createTestSession();
            phoneDescriptor = aSession.getClassDescriptor(PhoneNumber.class);
            phoneDescriptor.useMethodInstantiationPolicy("notExistStaticMethodOnDescriptor");
            aSession.login();
            aSession.readObject(PhoneNumber.class);
        }
        catch (Exception e) {
            hasException = true;
        }
        finally {
            if (aSession.isConnected()) {
                aSession.logout();
            }
        }
        if (!hasException) {
            throw new TestErrorException("Exeption should be throw when using a non-exist instatiation factory method on the Descriptor class");
        }
    }

    public PhoneNumber createPhoneNumber() {
        PhoneNumber phNumber = new PhoneNumber();
        phNumber.setType("instance");
        this.invokedFactoryPhoneNumberMethod = true;
        return phNumber;
    }

    public static InstantiationPolicyTest createPhoneNumberFactory() {
        invokedFactoryStaticMethod = true;
        return new InstantiationPolicyTest();
    }

    protected DatabaseSession createTestSession() {
        DatabaseSession aSession = new EmployeeProject().createDatabaseSession();
        aSession.setLogin((Login)this.getSession().getLogin().clone());
        aSession.setSessionLog(this.getSession().getSessionLog());
        aSession.logout();
        return aSession;
    }
}

