/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.Address;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Computer;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.Language;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;
import org.eclipse.persistence.testing.models.aggregate.Responsibility;

public class UnitOfWorkCommitResumeTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public UnitOfWork nestedUnitOfWork;
    public int changeVersion = 0;

    public UnitOfWorkCommitResumeTest() {
    }

    public UnitOfWorkCommitResumeTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        AddressDescription addressDescription = employee.getAddressDescription();
        ProjectDescription projectDescription = employee.getProjectDescription();
        Responsibility responsibility = Responsibility.example6(employee);
        String suffix = new Integer(this.changeVersion).toString();
        employee.setFirstName("First " + suffix);
        employee.setLastName("Last " + suffix);
        projectDescription.setDescription("ProjectDescription's Description changed" + suffix);
        addressDescription.getPeriodDescription().getPeriod().setEndDate(Helper.dateFromYearMonthDate((int)(1900 + (this.changeVersion + 1975) % 2500), (int)(this.changeVersion % 12 + 1), (int)(this.changeVersion % 28 + 1)));
        ((Address)addressDescription.getAddress().getValue()).setAddress(suffix + " Any Street");
        ((Computer)projectDescription.getComputer().getValue()).setDescription("Vic 20");
        responsibility.setResponsibility("Changed Reponsibility" + suffix);
        Vector responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        responsibilities.removeElement(responsibilities.firstElement());
        responsibilities.addElement(responsibility);
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        languages.removeElement(languages.firstElement());
        Language language = (Language)languages.firstElement();
        language.setLanguage("ModifiedLanguage" + suffix);
        languages.addElement(Language.example7());
        ++this.changeVersion;
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commitAndResume();
        this.changeUnitOfWorkWorkingCopy();
        this.unitOfWork.commitAndResume();
    }

    protected void verify() {
        if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
            throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
        }
        super.verify();
    }
}

