/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.session = null;
        this.classDetailsMap = null;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Session session;
        boolean shouldLogFinest;
        block18: {
            shouldLogFinest = ((AbstractSession)this.session).shouldLog(1, "weaver");
            Map classDetailsMap = this.classDetailsMap;
            session = this.session;
            if (classDetailsMap == null || session == null) {
                return null;
            }
            try {
                ClassDetails classDetails = (ClassDetails)classDetailsMap.get(Helper.toSlashedClassName(className));
                if (classDetails != null) {
                    if (shouldLogFinest) {
                        ((AbstractSession)session).log(1, "weaver", "begin_weaving_class", className);
                    }
                    ClassReader classReader = new ClassReader(classfileBuffer);
                    ClassWriter classWriter = null;
                    String introspectForHierarchy = System.getProperty("eclipselink.weaving.reflective-introspection", null);
                    classWriter = introspectForHierarchy != null ? new ClassWriter(2) : new ComputeClassWriter(loader, 2);
                    ClassWeaver classWeaver = new ClassWeaver(classWriter, classDetails);
                    SerialVersionUIDAdder sv = new SerialVersionUIDAdder(classWeaver);
                    classReader.accept(sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = classWriter.toByteArray();
                        String outputPath = System.getProperty("eclipselink.weaving.output.path", "");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile(className, bytes, outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_persistenceentity", className);
                            }
                            if (classWeaver.weavedChangeTracker) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_changetracker", className);
                            }
                            if (classWeaver.weavedLazy) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_lazy", className);
                            }
                            if (classWeaver.weavedFetchGroups) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_fetchgroups", className);
                            }
                            if (classWeaver.weavedRest) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_rest", className);
                            }
                            ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
                    }
                    break block18;
                }
                if (shouldLogFinest) {
                    ((AbstractSession)session).log(1, "weaver", "transform_missing_class_details", className);
                }
            }
            catch (Throwable exception) {
                ((AbstractSession)session).log(6, "weaver", "exception_while_weaving", new Object[]{className, exception.getLocalizedMessage()});
                if (!shouldLogFinest) break block18;
                ((AbstractSession)session).logThrowable(1, "weaver", exception);
            }
        }
        if (shouldLogFinest) {
            ((AbstractSession)session).log(1, "weaver", "transform_existing_class_bytes", className);
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

