/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class DescriptorGenerationDialog
extends AbstractValidatingDialog {
    private MWRelationalProject project;
    private JTextField packageNameTextField;
    private JCheckBox generateAccessorsCheckBox;

    public DescriptorGenerationDialog(MWRelationalProject project, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.project = project;
        this.initializeDialog();
    }

    public boolean getGenerateAccessors() {
        return this.generateAccessorsCheckBox.isSelected();
    }

    public String getPackageName() {
        return this.packageNameTextField.getText();
    }

    @Override
    protected String helpTopicId() {
        return "dialog.descriptorGeneration";
    }

    private void initializeDialog() {
        String titleString = null;
        titleString = "DescriptorGenerationDialog_class.title";
        this.setResizable(true);
        this.setTitle(this.resourceRepository().getString(titleString));
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JLabel packageNameLabel = SwingComponentFactory.buildLabel("DescriptorGenerationDialog_packageName", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)packageNameLabel, constraints);
        this.packageNameTextField = new JTextField();
        this.packageNameTextField.setColumns(30);
        RegexpDocument packageNameDocument = new RegexpDocument(1);
        packageNameDocument.addDocumentListener(this.buildPackageNameDocumentListener());
        this.packageNameTextField.setDocument(packageNameDocument);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        mainPanel.add((Component)this.packageNameTextField, constraints);
        packageNameLabel.setLabelFor(this.packageNameTextField);
        this.generateAccessorsCheckBox = new JCheckBox(this.resourceRepository().getString("DescriptorGenerationDialog_generateAccessingMethods"), true);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        mainPanel.add((Component)this.generateAccessorsCheckBox, constraints);
        Spacer spacer = new Spacer();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)spacer, constraints);
        return mainPanel;
    }

    void showNoRelationshipSupportDialog() {
        JOptionPane.showMessageDialog(this, this.resourceRepository().getString("DescriptorGenerationDialog_noRelationshipSupport.message"), this.resourceRepository().getString("DescriptorGenerationDialog_noRelationshipSupport.title"), 2);
    }

    protected DocumentListener buildPackageNameDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DescriptorGenerationDialog.this.packageNameDocumentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DescriptorGenerationDialog.this.packageNameDocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    void packageNameDocumentChanged() {
        if (this.isVisible()) {
            this.validatePackageName();
        }
    }

    private void validatePackageName() {
        String pkgName = this.packageNameTextField.getText();
        if (this.packageNameIsIllegal(pkgName)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    private boolean packageNameIsIllegal(String name) {
        String[] segments = name.split("\\.");
        for (int i = 0; i < segments.length; ++i) {
            if (!NameTools.javaReservedWordsContains((String)segments[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setErrorMessageKey(String key) {
        super.setErrorMessageKey(key);
        this.getOKAction().setEnabled(false);
    }

    @Override
    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.getOKAction().setEnabled(true);
    }
}

