/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.TextAreaDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class ExceptionDialog
extends AbstractDialog {
    private String message;
    private Throwable exception;

    public ExceptionDialog(String message, Throwable exception, WorkbenchContext context, String title) {
        super(context, title);
        this.message = message;
        this.exception = exception;
    }

    public ExceptionDialog(String message, Throwable exception, WorkbenchContext context, Dialog owner, String title) {
        super(context, title, owner);
        this.message = message;
        this.exception = exception;
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridLayout(0, 1));
        JLabel messageLabel = new JLabel();
        messageLabel.setText(this.message);
        messageLabel.setIcon(this.resourceRepository().getIcon("warning"));
        messageLabel.setHorizontalAlignment(0);
        mainPanel.add(messageLabel);
        JLabel exceptionLabel = new JLabel(this.exception.getClass().getName(), 0);
        mainPanel.add(exceptionLabel);
        return mainPanel;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.unexpectedError";
    }

    @Override
    protected Iterator buildCustomActions() {
        Action stackTraceAction = this.buildStackTraceAction();
        return new SingleElementIterator((Object)stackTraceAction);
    }

    private Action buildStackTraceAction() {
        return new AbstractAction(this.buildStackTraceText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.displayStackTrace();
            }
        };
    }

    protected String buildStackTraceText() {
        return this.resourceRepository().getString("STACK_TRACE");
    }

    protected void displayStackTrace() {
        TextAreaDialog dialog = new TextAreaDialog(this.exception, this.helpTopicId(), this.getWorkbenchContext(), (Dialog)this);
        dialog.setTitle(this.buildStackTraceText());
        dialog.show();
    }
}

