/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class MemberRefConstant
extends Constant {
    private short classIndex;
    private short nameAndTypeIndex;

    MemberRefConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.classIndex = stream.readU2();
        this.nameAndTypeIndex = stream.readU2();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" class: ");
        writer.print(this.className());
        writer.print("  name: ");
        writer.print(this.name());
        writer.print("  descriptor: ");
        writer.println(this.descriptor());
    }

    public String className() {
        return this.classConstant().name();
    }

    public ClassConstant classConstant() {
        return this.getPool().getClassConstant(this.classIndex);
    }

    public String name() {
        return this.nameAndTypeConstant().name();
    }

    public String descriptor() {
        return this.nameAndTypeConstant().descriptor();
    }

    public NameAndTypeConstant nameAndTypeConstant() {
        return this.getPool().getNameAndTypeConstant(this.nameAndTypeIndex);
    }

    public short getClassIndex() {
        return this.classIndex;
    }

    public short getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    @Override
    public Object value() {
        return this.className() + '.' + this.name() + ':' + this.descriptor();
    }
}

