/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Employee;

public class AggregateInvalidationIdentityTest
extends AutoVerifyTestCase {
    DatabaseSession session;
    Employee originalEmployee;
    Employee refreshedEmployee;
    AddressDescription originalAddressDescription;
    AddressDescription refreshedAddressDescription;

    public AggregateInvalidationIdentityTest() {
        this.setDescription("Tests that identity is maintained for an aggregate, if the parent is invalidated and then re-read");
    }

    protected void setup() {
        this.beginTransaction();
        this.session = (DatabaseSession)this.getSession();
        UnitOfWork uow = this.session.acquireUnitOfWork();
        this.originalEmployee = Employee.example1();
        this.originalAddressDescription = this.originalEmployee.getAddressDescription();
        uow.registerObject((Object)this.originalEmployee);
        uow.commit();
    }

    public void test() {
        this.session.getIdentityMapAccessor().invalidateObject((Object)this.originalEmployee);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionObject((Object)this.originalEmployee);
        this.refreshedEmployee = (Employee)this.session.executeQuery((DatabaseQuery)query);
        this.refreshedAddressDescription = this.refreshedEmployee.getAddressDescription();
    }

    public void verify() {
        if (this.refreshedEmployee.hashCode() != this.originalEmployee.hashCode()) {
            this.throwError("Employee's identity is different from the original Employee");
        }
        if (this.refreshedAddressDescription.hashCode() != this.originalAddressDescription.hashCode()) {
            this.throwError("AddressDescription's identity is different from the original AddressDescription");
        }
    }

    public void reset() {
        this.session = null;
        this.rollbackTransaction();
    }
}

