/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.concurrent;

import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.jpa.performance.Address;

public class JPAUpdateAddressConcurrencyComparisonTest
extends ConcurrentPerformanceComparisonTest {
    protected List<Address> addresses;
    protected String street;
    protected int index;
    protected long count;
    protected int errors;

    public JPAUpdateAddressConcurrencyComparisonTest() {
        this.setDescription("This test compares the concurrency of update Address.");
    }

    public synchronized int incrementIndex() {
        ++this.index;
        if (this.index >= this.addresses.size()) {
            this.index = 0;
        }
        return this.index;
    }

    public void setup() {
        super.setup();
        EntityManager manager = this.createEntityManager();
        this.addresses = manager.createQuery("Select a from Address a").getResultList();
        this.street = this.addresses.get(0).getStreet();
        manager.close();
        this.index = 0;
        this.count = 0L;
    }

    public void runTask() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Address address = (Address)manager.find(Address.class, (Object)this.addresses.get(this.incrementIndex()).getId());
        ++this.count;
        address.setStreet(this.street + this.count);
        try {
            manager.getTransaction().commit();
        }
        catch (Exception exception) {
            ++this.errors;
            System.out.println("" + this.errors + ":" + exception);
        }
        manager.close();
    }
}

