/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Session;

public class DefaultConnector
implements Connector {
    protected String driverClassName;
    protected String driverURLHeader;
    protected String databaseURL;
    protected Class driverClass;
    protected Driver driver;
    private boolean connectDirectly = false;

    public DefaultConnector() {
    }

    public DefaultConnector(String driverClassName, String driverURLHeader, String databaseURL) {
        this.initialize(driverClassName, driverURLHeader, databaseURL);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    @Override
    public Connection connect(Properties properties, Session session) throws DatabaseException {
        SQLException driverManagerException;
        block12: {
            String connectionString;
            if (this.driverClassName != null && this.driverClass == null) {
                this.loadDriverClass(session);
            }
            if ((connectionString = this.getConnectionString()) == null || connectionString.trim().equals("")) {
                throw DatabaseException.unableToAcquireConnectionFromDriverException(this.driverClassName, null, connectionString);
            }
            driverManagerException = null;
            if (this.shouldUseDriverManager(properties, session)) {
                try {
                    return DriverManager.getConnection(this.getConnectionString(), properties);
                }
                catch (SQLException sqlException) {
                    driverManagerException = sqlException;
                    if (session == null) break block12;
                    ((AbstractSession)session).log(2, "connection", "connect_drivermanager_fail");
                    ((AbstractSession)session).logThrowable(2, "connection", sqlException);
                }
            }
        }
        if (this.driverClass == null) {
            throw DatabaseException.sqlException(driverManagerException, (AbstractSession)session, true);
        }
        boolean wrongDriverExceptionOccurred = false;
        try {
            Connection directConnection = this.directConnect(properties);
            if (directConnection == null) {
                if (driverManagerException != null) {
                    wrongDriverExceptionOccurred = true;
                    throw DatabaseException.unableToAcquireConnectionFromDriverException(driverManagerException, this.getDriverClassName(), properties.getProperty("user"), this.getDatabaseURL());
                }
                throw DatabaseException.unableToAcquireConnectionFromDriverException(this.getDriverClassName(), this.driverClass.getCanonicalName(), this.getDatabaseURL());
            }
            if (driverManagerException != null) {
                this.connectDirectly = true;
            }
            return directConnection;
        }
        catch (DatabaseException directConnectException) {
            if (driverManagerException != null && !wrongDriverExceptionOccurred) {
                throw DatabaseException.sqlException(driverManagerException, (AbstractSession)session, true);
            }
            throw directConnectException;
        }
    }

    public boolean shouldUseDriverManager(Properties properties, Session session) {
        return !this.connectDirectly && (session == null || session.getServerPlatform().shouldUseDriverManager());
    }

    protected Connection directConnect(Properties properties) throws DatabaseException {
        if (this.driver == null) {
            this.instantiateDriver();
        }
        try {
            return this.driver.connect(this.getConnectionString(), properties);
        }
        catch (SQLException exception) {
            this.clearDriverClassAndDriver();
            throw DatabaseException.sqlException(exception, true);
        }
    }

    public String getConnectionString() {
        if (this.getDriverURLHeader() == null) {
            return this.getDatabaseURL();
        }
        if (this.getDatabaseURL() == null) {
            return this.getDriverURLHeader();
        }
        return String.valueOf(this.getDriverURLHeader()) + this.getDatabaseURL();
    }

    @Override
    public String getConnectionDetails() {
        return this.getConnectionString();
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverURLHeader() {
        return this.driverURLHeader;
    }

    protected void initialize(String driverClassName, String driverURLHeader, String databaseURL) {
        this.setDriverClassName(driverClassName);
        this.setDriverURLHeader(driverURLHeader);
        this.setDatabaseURL(databaseURL);
    }

    protected void loadDriverClass(Session session) throws DatabaseException {
        block9: {
            try {
                if (session != null) {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.driverClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getDriverClassName(), true, session.getPlatform().getConversionManager().getLoader()));
                            break block9;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
                        }
                    }
                    this.driverClass = PrivilegedAccessHelper.getClassForName(this.getDriverClassName(), true, session.getPlatform().getConversionManager().getLoader());
                    break block9;
                }
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.driverClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader()));
                        break block9;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
                    }
                }
                this.driverClass = PrivilegedAccessHelper.getClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
            }
        }
    }

    public void setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        this.clearDriverClassAndDriver();
    }

    public void setDriverURLHeader(String driverURLHeader) {
        this.driverURLHeader = driverURLHeader;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.getConnectionString() + ")";
    }

    @Override
    public void toString(PrintWriter writer) {
        writer.println(String.valueOf(ToStringLocalization.buildMessage("datasource_URL", null)) + "=> \"" + this.getConnectionString() + "\"");
    }

    protected void instantiateDriver() throws DatabaseException {
        block8: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.driver = (Driver)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.driverClass));
                        break block8;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof IllegalAccessException) {
                            throw (IllegalAccessException)ex.getCause();
                        }
                        if (ex.getCause() instanceof InstantiationException) {
                            throw (InstantiationException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                this.driver = (Driver)PrivilegedAccessHelper.newInstanceFromClass(this.driverClass);
            }
            catch (InstantiationException ie) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorNewInstanceInstantiationException(ie, this.driverClass);
            }
            catch (IllegalAccessException iae) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorNewInstanceIllegalAccessException(iae, this.driverClass);
            }
        }
    }

    public void clearDriverClassAndDriver() {
        this.driverClass = null;
        this.driver = null;
    }
}

