/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.app.ActiveIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.SelectionActionsPolicy;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public abstract class MappingNode
extends MappingsApplicationNode {
    private PropertyChangeListener attributeNameListener;
    private PropertyChangeListener attributeTypeDeclarationListener;
    private SelectionActionsPolicy mappingNodeTypePolicy;
    protected static final String[] MAPPING_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    private static final Icon INHERITED_ICON = new DefaultIconRepository(new MappingsPluginIconResourceFileNameMap()).getIcon("inherited");

    protected MappingNode(MWModel value, ApplicationContext context, SelectionActionsPolicy mappingNodeTypePolicy, MappingDescriptorNode parent) {
        super(value, (TreeNodeValueModel)parent, parent.getPlugin(), context);
        this.mappingNodeTypePolicy = mappingNodeTypePolicy;
    }

    protected MappingNode(MWModel value, SelectionActionsPolicy mappingNodeTypePolicy, MappingDescriptorNode parent) {
        this(value, parent.getApplicationContext(), mappingNodeTypePolicy, parent);
    }

    protected void initialize() {
        super.initialize();
        this.attributeNameListener = this.buildAttributeNameListener();
        this.attributeTypeDeclarationListener = this.buildAttributeTypeDeclarationListener();
    }

    private PropertyChangeListener buildAttributeNameListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MappingNode.this.attributeNameChanged();
            }

            public String toString() {
                return "attribute name listener";
            }
        };
    }

    private PropertyChangeListener buildAttributeTypeDeclarationListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MappingNode.this.attributeTypeDeclarationChanged();
            }

            public String toString() {
                return "attribute type declaration listener";
            }
        };
    }

    @Override
    protected void engageValue() {
        super.engageValue();
        this.descriptor().addPropertyChangeListener("active", this.getValueIconListener());
        this.descriptor().addPropertyChangeListener("active", this.getValuePropertiesPageTitleIconListener());
        this.instanceVariable().addPropertyChangeListener("name", this.attributeNameListener);
        this.instanceVariable().addPropertyChangeListener("declaration", this.attributeTypeDeclarationListener);
    }

    @Override
    protected void disengageValue() {
        this.instanceVariable().removePropertyChangeListener("declaration", this.attributeTypeDeclarationListener);
        this.instanceVariable().removePropertyChangeListener("name", this.attributeNameListener);
        this.descriptor().removePropertyChangeListener("active", this.getValuePropertiesPageTitleIconListener());
        this.descriptor().removePropertyChangeListener("active", this.getValueIconListener());
        super.disengageValue();
    }

    @Override
    protected String[] displayStringPropertyNames() {
        return MAPPING_DISPLAY_STRING_PROPERTY_NAMES;
    }

    @Override
    protected IconBuilder buildIconBuilder() {
        CompositeIconBuilder inheritedIconBuilder = new CompositeIconBuilder(super.buildIconBuilder(), this.mappingIsInherited(), INHERITED_ICON, -3, 0, 0, null);
        return new ActiveIconBuilder(inheritedIconBuilder, this.descriptor().isActive());
    }

    @Override
    protected String buildPropertiesPageTitleText() {
        return this.getMapping().nameWithShortType();
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext localContext = this.buildLocalWorkbenchContext(workbenchContext);
        GroupContainerDescription desc = this.mappingNodeTypePolicy.buildMenuDescription(localContext);
        desc.add(this.buildOracleHelpMenuGroup(localContext));
        return desc;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return this.mappingNodeTypePolicy.buildToolBarDescription(this.buildLocalWorkbenchContext(workbenchContext));
    }

    @Override
    public String candidatePackageName() {
        return this.getDescriptorNode().candidatePackageName();
    }

    @Override
    public boolean isAutoMappable() {
        return false;
    }

    public Iterator descriptors() {
        return new SingleElementIterator((Object)this.descriptor());
    }

    @Override
    public void addDescriptorsTo(Collection descriptors) {
        descriptors.add(this.descriptor());
    }

    public MWMapping getMapping() {
        return (MWMapping)this.getValue();
    }

    public MWClassAttribute instanceVariable() {
        return this.getMapping().getInstanceVariable();
    }

    public MappingDescriptorNode getDescriptorNode() {
        return (MappingDescriptorNode)this.getParent();
    }

    public MWMappingDescriptor descriptor() {
        return this.getDescriptorNode().getMappingDescriptor();
    }

    public boolean mappingIsInherited() {
        return this.getMapping().isInherited();
    }

    public boolean isMapped() {
        return true;
    }

    public boolean isUnmapped() {
        return !this.isMapped();
    }

    public MWDatabase database() {
        return this.descriptor().getDatabase();
    }

    protected void attributeNameChanged() {
        if (this.isMapped()) {
            this.getMapping().setName(this.instanceVariable().getName());
        }
    }

    protected void attributeTypeDeclarationChanged() {
        this.propertiesPageTitleTextChanged();
    }

    void remove() {
        MWMapping mapping = this.getMapping();
        this.descriptor().removeMapping(mapping);
        this.removeInstanceVariable();
    }

    void removeInstanceVariable() {
        MWClassAttribute iv = this.instanceVariable();
        if (this.mappingIsInherited()) {
            this.descriptor().removeInheritedAttribute(iv);
        } else if (iv.isEjb20Attribute()) {
            iv.getDeclaringType().removeEjb20Attribute(iv);
        } else {
            iv.getDeclaringType().removeAttribute(iv);
        }
    }
}

